% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/access_head.R
\name{access_head}
\alias{access_head}
\title{Convert YAML to an accessible header}
\usage{
access_head(
  rmd_path = NULL,
  lan = detect_html_lang(lines),
  inplace = FALSE,
  encoding = "utf-8",
  theme = "default",
  highlight = "null"
)
}
\arguments{
\item{rmd_path}{Path to the Rmd that requires accessible header metadata. Rmd
must be output type html.}

\item{lan}{Identify the language of text content. Attempts to find a lang
attribute value from the rmd document. Alternatively, use a character string
such as "en".}

\item{inplace}{When set to FALSE (the default) writes to new file. If TRUE,
writes in place.}

\item{encoding}{Defaults to utf-8.}

\item{theme}{Set to "default", currently the only in-built theme that does
not result in accessibility errors.}

\item{highlight}{Set to "null", currently the only in-built highlight that
does not result in accessibility errors.}
}
\value{
Adjust the Rmd YAML provided to \code{rmd_path}, improving its
accessibility for screen readers. Only works with html output.
}
\description{
Reads an Rmd file, converting the YAML header to a format that is screen
reader friendly.
}
\examples{
\dontshow{
.old_wd <- setwd(tempdir())
}
# create a testfile
rmd <- tempfile("testing", fileext = ".rmd")
# write basic markdown content
writeLines('---
title: "testfile"
author: "Some Author"
date: "`r format(Sys.Date(), "\%d \%b \%Y")`"
output: html_document
---

 ```{r setup, include=FALSE}
knitr::opts_chunk$set(echo = TRUE)
```

## R Markdown', con = rmd)

# Adjust the document header to improve screen reader accessibility
access_head(rmd, lan = "en")
\dontshow{
setwd(.old_wd)
}

}
