% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accrual_time_unit.R
\name{accrual_time_unit}
\alias{accrual_time_unit}
\title{accrual_time_unit}
\usage{
accrual_time_unit(accrual_df, unit = c("month", "year", "week", "day"))
}
\arguments{
\item{accrual_df}{accrual data frame produced by \code{accrual_create_df} with by=NA.}

\item{unit}{time unit for which the bars should be plotted,
one of \code{"month"}, \code{"year"}, \code{"week"} or \code{"day"}.}
}
\value{
Returns a data frame with the number of patients accrued for each time unit.
}
\description{
Generates summary of recruitment per time unit
}
\examples{
\donttest{
data(accrualdemo)
accrual_df<-accrual_create_df(accrualdemo$date)
accrual_time_unit(accrual_df,"week")
accrual_time_unit(accrual_df,"day")
}

}
