% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gddcal.R
\name{gddcal}
\alias{gddcal}
\title{Calculating growing season degree days}
\usage{
gddcal(tL, tU, tMin, tMax, tMin2 = NULL, method = NULL)
}
\arguments{
\item{tL}{Lower temperature threshold}

\item{tU}{Upper temperature threshold}

\item{tMin}{Minimum temperature}

\item{tMax}{Maximum temperature}

\item{tMin2}{Minimum temperature for the second half day}

\item{method}{GDD calculation methods (default = single sine method)}
}
\value{
A numeric of growing season degree days (GDDs)
}
\description{
The function calculates the growing season degree days (GDDs) using single/double triangulation/sine methods.
}
\details{
\code{gddcal} is a function for calculating growing season degree days (GDDs) through four approaches popularly used in agricultural production or relevant fields.\cr 
\cr
- \code{method = 'stri'}: single triangulation method
\cr
- \code{method = 'dtri'}: double triangulation method (need \code{tMin2})
\cr
- \code{method = 'ssin'}: single sine method
\cr
- \code{method = 'dsin'}: double sine method (need \code{tMin2})\cr
\cr
The default is the single sine method. i.e., if \code{method} is not specified, \code{gddcal} uses the single sine method. For two double methods (\code{'dtri'} and \code{'dsin'}), a second half day minimum temperature needs to be specified.
}
\examples{
## Single Triangulation Method
gddcal(55,90,50,82,'stri')
## Double Triangulation Method
gddcal(55,90,50,82,45,'dtri')
## Single Sine Method
gddcal(55,90,50,82)
gddcal(55,90,50,82,'ssin')
## Double Sine Method
gddcal(55,90,50,82,45,'dsin')
}
\references{
Zalom, F. G., P. B. Goodell, Lloyd T. Wilson, W. W. Barnett, and W. J. Bentley. (1983) "Degree-Days, the Calculation and Use of Heat Units in Pest Management." \emph{Division of Agriculture and Natural Resources, University of California}. 1-11.
}
\seealso{
\code{\link{gddprism}}
}
