% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/engines.R
\name{engines}
\alias{engines}
\alias{acronym}
\alias{initialism}
\title{acroname engines}
\usage{
acronym(
  input,
  dictionary = NULL,
  acronym_length = 3,
  ignore_articles = TRUE,
  alnum_only = TRUE,
  timeout = 60,
  bow = FALSE,
  bow_prop = 0.5,
  to_tibble = FALSE
)

initialism(
  input,
  ignore_articles = TRUE,
  alnum_only = TRUE,
  bow = FALSE,
  bow_prop = 0.5,
  to_tibble = FALSE
)
}
\arguments{
\item{input}{Character vector with text to use as the input for the candidate}

\item{dictionary}{Character vector containing dictionary of terms from which acronym should be created; default is \code{NULL} and \code{hunspell} "en_us" dictionary will be used}

\item{acronym_length}{Number of characters in acronym; default is \code{3}}

\item{ignore_articles}{Logical indicating whether or not articles should be ignored ; default is \code{TRUE}}

\item{alnum_only}{Logical that specifes whether only alphanumeric should be used; default is \code{TRUE}}

\item{timeout}{Maximum seconds to spend searching for an acronym; default is \code{60}}

\item{bow}{Logical for whether or not a "bag of words" approach should be used for "input" vector; default is \code{FALSE}}

\item{bow_prop}{Given \code{bow = TRUE} this specifies the proportion of words to sample; ignored if \code{bow = FALSE}; default is \code{0.5}}

\item{to_tibble}{Logical as to whether or not the result should be a \code{tibble}; default is \code{FALSE}}
}
\value{
If \code{to_tibble = FALSE} (default), then a character vector containing the name capitalized followed by the original string with letters used in the name capitalized.

If \code{to_tibble = TRUE}, then a \code{tibble} with the following columns:
\itemize{
\item \strong{formatted}: The candidate name and string with letters used capitalized
\item \strong{prefix}: The candidate name
\item \strong{suffix}: Words used with letters in name capitalized
\item \strong{original}: The original string used to construct the name
}
}
\description{
The \code{acroname} engines include methods to generate acronyms and initialisms. \code{acronym()} searches for candidates by constructing words from characters provided. Each word constructed is compared to the terms in the dictionary specified, and once a match is found the acronym is returned. \code{initialism()} takes the first characters from each word in the string. Both functions can optionally return a \code{tibble}, ignore articles, and/or use a "bag of words" approach (for more see \link[acroname]{mince}).
}
