% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_clean.R
\name{do_clean}
\alias{do_clean}
\title{Cleaning outliers}
\usage{
do_clean(data, num_pts, range = 1.5, out_perc = 80)
}
\arguments{
\item{data}{Data frame with (temporal) points in the rows and observations in 
the columns.}

\item{num_pts}{Number of temporal points.}

\item{range}{Same parameter as in function \code{\link{boxplot}}. 
A value of 1.5 is enough to detect amplitude and shift outliers, while a value
of 3 is needed to detect isolated outliers.}

\item{out_perc}{Minimum number of temporal points (in percentage) to consider 
the observation as an outlier. Needed when \code{range=1.5}.}
}
\value{
Numeric vector with the outliers.
}
\description{
Cleaning of the most remarkable outliers. This improves the performance of 
the archetypoid algorithm since it is not affected by spurious points.
}
\examples{
data(mtcars)
data <- mtcars
num_pts <- ncol(data)
do_clean(t(data), num_pts, 1.5, 80)

}
\seealso{
\code{\link{boxplot}}
}
\author{
Irene Epifanio
}
