% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Udaplotfnc.R
\name{udaplot}
\alias{udaplot}
\title{Creates Uda-plot for the provided data with and without the estimated normal density curve, excluding extreme values.}
\usage{
udaplot(X, excld = FALSE, npdf = FALSE, title = ifelse(npdf == FALSE, "Uda-plot",
       "Uda-plot & Normal Density Curve"), xlab = "x", lcol = "black", rcol = "grey60",
       pdfcol = "red",...)
}
\arguments{
\item{X}{an \eqn{n} by \eqn{1} matrix, equivalently, a column vector of length \eqn{n}, where \eqn{n} is the number of observations.}

\item{excld}{exclude extreme values in the data applying 1.5IQR rule, \emph{FALSE} by default.}

\item{npdf}{display of the estimated normal density curve in the Uda-plot, \emph{FALSE} by default.}

\item{title}{title of the plot, \emph{Uda-plot} by default and \emph{Uda-plot & Normal Density Curve} if npdf is \emph{TRUE}.}

\item{xlab}{\eqn{x}-axis label, \eqn{x} by default.}

\item{lcol}{color of the points which correspond to data on or below the sample average, \emph{black} by default.}

\item{rcol}{color of the points which correspond to data above the sample average, \emph{grey60} by default.}

\item{pdfcol}{color of the estimated normal density curve, \emph{red} by default.}

\item{...}{other graphical parameters.}
}
\value{
Uda-plot
}
\description{
Uda-plot can be utilized to assess normality.
}
\examples{
   set.seed(0)
   X1 <- matrix(c(rnorm(50, mean = 2, sd = 5), runif(4, 17, 30)))
   udaplot(X1)

   X2 <- matrix(c(rnorm(50, mean = 2, sd = 5), runif(4, 17, 30)))
   udaplot(X2, npdf = TRUE)

   X3 <- matrix(c(rnorm(50, mean = 2, sd = 5), runif(4, 17, 30)))
   udaplot(X3, excld = TRUE, npdf = TRUE)

   X4 <- matrix(rnorm(500, mean = 2, sd = 5))
   udaplot(X4, title = "", lcol = "blue", rcol = "red", pdfcol = "balck")
}
\references{
Wijesuriya, U. A. (2025a). Ada-plot and Uda-plot as Alternatives for
            Ad-plot and Ud-plot.
            \emph{Communications in Statistics-Theory and Methods}, \doi{10.1080/03610926.2025.2558108}.

Wijesuriya, U. A. (2025b). Ad-plot and Ud-plot for Determining Distributional Characteristics
            and Normality.
            \emph{Communications in Statistics-Theory and Methods}, \doi{10.1080/03610926.2024.2440583}.

Wijesuriya, U. A. (2025c). adplots: Ad-plot and Ud-plot for Visualizing Distributional
            Properties and Normality.
            \emph{R Package Version 0.1.0}, \doi{10.32614/CRAN.package.adplots}.
}
