% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ah.R
\name{ah}
\alias{ah}
\title{Fit Additive Hazards Regression Models}
\usage{
ah(formula, data, robust, weights, ties, ...)
}
\arguments{
\item{formula}{a formula object for the regression model of the form
response ~ predictors. The outcome is a survival object created by
\code{\link[survival]{Surv}}.}

\item{data}{a data frame. Input dataset.}

\item{robust}{a logical variable.  Robust standard errors are provided if
robust == TRUE.}

\item{weights}{a numeric vector. The weight of each observation.}

\item{ties}{a logical variable. FALSE if there are no ties in the censored failure times.}

\item{...}{additional arguments to be passed to the low level regression
fitting functions.}
}
\value{
An object of class 'ah' representing the fit.
}
\description{
Fit a semiparametric additive hazard model
'\deqn{ \lambda(t|Z=z) = \lambda_0(t) + \beta'z.}
The estimating procedures follow Lin & Ying (1994).
}
\note{
The response variable is a survival object. If there are ties in the
 survival time, in the current version we recommend users to break ties by adding
 a small random number to the survival time. An example is provided.  The regression
 model can be univariate or multivariate. This package is built upon the function
 \code{\link[ahaz]{ahaz}} by Anders Gorst-Rasmussen.
}
\examples{
library(survival)
### using the first 100 rows in nwtsco to build an additive hazards model
nwts<- nwtsco[1:100,]

### fit the additive hazards model to the data
### the model-based standard errors are reported when setting robust = FALSE
fit1 <- ah(Surv(trel,relaps) ~ age + instit, ties = FALSE, data = nwts, robust = FALSE)
summary(fit1)

### fit the additive hazards model to the data with robust standard errors
fit2 <- ah(Surv(trel,relaps) ~ age + instit, ties = FALSE, data = nwts, robust = TRUE)
summary(fit2)

### when there are ties, break the ties first
nwts_all <- nwtsco
nwts_all$trel <- nwtsco$trel + runif(dim(nwts_all)[1],0,1)*1e-8
fit3 <- ah(Surv(trel,relaps) ~ age + instit, ties = FALSE, data = nwts_all, robust = TRUE)
summary(fit3)
}
\references{
Lin, D.Y. & Ying, Z. (1994). Semiparametric analysis of the additive risk model.
                             Biometrika; 81:61-71.
}
\seealso{
\code{\link{predict.ah}} for prediction based on fitted
 \code{\link{ah}} model, \code{\link{nwtsco}} for the description of nwtsco dataset
}

