"_PACKAGE"
#' Data Envelopment Analysis: Variable Selection, Constrained ADEA and Leverage Units
#'
#' @aliases adea-package
#' @name adea-package
#'
#' @description
#' \preformatted{
#'
#' Package: adea
#'
#' Version: 1.5.2
#'
#' Date: 2024-11-06
#'
#' License: GPL (>= 3)
#' }
#' 
#' Data Envelopment Analysis (DEA) involves evaluating the efficiency of a set of Decision Making Units (DMUs) and calculating a relative efficiency score for each DMU. 
#' These scores are determined as a weighted ratio between all inputs and outputs amounts for such DMU.
#'
#' DEA methodology assumes that all DMUs use the same set of inputs to produce the same set of outputs. 
#'
#' @section Variable selection:
#'
#' The selection of input and output variables for inclusion in a DEA model is a crucial aspect, as numerous studies have shown.
#' This package offers two variable selection procedures.
#' The first is ADEA, which is based on a measure of the relative importance of variables in the entire set of scores.
#' For more information on this methodology, see \code{\link{adea}}.
#' 
#' An alternative way to select the variables for the model is by solving a mathematical optimization problem that determines the optimal selection based on some performance criteria.
#' \code{\link{fsdea}} function provides an implementation of this procedure.
#'
#' @section Function Index:
#'
#' The main functions provided by this package are:
#' \itemize{
#'    \item adea: Conducts ADEA analysis, providing efficiency scores for each DMU, a set of weights, and loads for each input and output variable, along with a model load.
#'    \item adea_parametric: Does a stepwise analysis of removing variables step by steps. adea_hierarchical works in similar way.
#'    \item fsea: Selects an optimal subset of input and output variables based on some performance criteria.
#'    \item cadea: Performs Constrained ADEA analysis to enforce variable load constraints within a specified range, resulting in changes to efficiency scores.
#'    \item adea_load_average: Identifies DMUs with a higher impact on the ADEA model.
#' }
#'
#' 
#' @note This package is translation-ready, and contributions of translated versions of po files are highly welcome.
#' 
#' @author Fernando Fernandez-Palacin <fernando.fernandez@uca.es> and Manuel Munoz-Marquez <manuel.munoz@uca.es>
#'
#' Mantainer: Manuel Munoz-Marquez <manuel.munoz@uca.es>
#'
#' @keywords package DEA
#'
#' @references A new approach to the bi-dimensional representation of the DEA efficient frontier with multiple inputs and outputs. 
#' \emph{Carlos A. Bana e Costa} and \emph{Joao Carlos C. B. Soares de Mello}, and \emph{Lidia Angulo Meza}.
#' European Journal of Operational Research, 255 (1), pg. 175-186, 2016,
#' <DOI:10.1016/j.ejor.2016.05.012>.
#'
#' @references Stepwise Selection of Variables in DEA Using Contribution Load.
#' \emph{F. Fernandez-Palacin}, \emph{M. A. Lopez-Sanchez}, and \emph{M. Munoz-Marquez}.
#' Pesquisa Operacional 38 (1), pg. 1-24, 2018.
#' <DOI:10.1590/0101-7438.2018.038.01.0000>.
#'
#' @references Feature Selection in Data Envelopment Analysis: A Mathematical Optimization approach.
#' \emph{Benitez-Pena, S.}, \emph{Bogetoft, P.}, and \emph{Romero Morales, D.}.
#' Omega, Elsevier BV, 96, pp. 102068, 2020.
#' <DOI:10.1016/j.omega.2019.05.004>
#'
#' @references Methodology for calculating critical values of relevance measures in variable selection methods in data envelopment analysis.
#' \emph{Jeyms Villanueva-Cantillo} and \emph{Manuel Munoz-Marquez}.
#' European Journal of Operational Research, 290 (2), pg. 657-670, 2021.
#' <DOI:10.1016/j.ejor.2020.08.021>.
#'
#' @import knitr
#' @import methods
#' @import rmarkdown
#' @import ROI
#' @import ROI.plugin.glpk
#' @import ROI.plugin.lpsolve
#' @import ROI.plugin.symphony
#' @import stats
NULL
