% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{get_example_design}
\alias{get_example_design}
\title{Generate an exemplary adaptive design}
\usage{
get_example_design(two_armed = FALSE, label = NULL)
}
\arguments{
\item{two_armed}{(logical) determins whether the design is for one- or
two-armed trials.}

\item{label}{(optional) label to be assigned to the design.}
}
\value{
an exemplary design of class \code{TwoStageDesign}. This object
contains information about the sample size recalculation rule \code{n2}, the
futility and efficacy boundaries \code{c1f} and \code{c1e} and the
second-stage rejection boundary \code{c2}.
}
\description{
The design was optimized to minimize the expected sample size
under the alternative hypothesis for a one-armed trial.
The boundaries are chosen to control the type I error at 0.025
for a normally distributed test statistic (i.e. known variance).
For an alternative hypothesis of mu=0.4, the overall power is 80\%.
}
\examples{
get_example_design()

}
