% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survCOX.R
\name{survCOX}
\alias{survCOX}
\title{Stratified Marginal Proportional Hazards Model For Clustered Survival Data}
\usage{
survCOX(
  times,
  deltas,
  covariates,
  treatment = NULL,
  clusters = 1:length(times),
  stratified.model = TRUE,
  est.t = FALSE,
  pre.t = sort(times[deltas == 1]),
  Z0 = NULL
)
}
\arguments{
\item{times}{Vector of failure/censored times.}

\item{deltas}{Event indicator with 1 as an event and 0 as censoring.}

\item{covariates}{Matrix of covariates. For categorical covariates, dummy variable must be created.}

\item{treatment}{Vector of treatment variable. This is also the strata variable. It is a vector
with numeric code for each group or stratum.}

\item{clusters}{Vector of clustering variable. Independent data are assumed if not provided.}

\item{stratified.model}{\code{TRUE} or \code{FALSE}. By default, it is \code{TRUE} for stratified model. The stratification variable is \code{treatment}.
If this is \code{FALSE} and \code{est.t=TRUE}, then the \code{treatment} variable still needs to be provided and will be used as a covariate.}

\item{est.t}{\code{TRUE} or \code{FALSE}. By default this is \code{FALSE}. If \code{TRUE} then estimates of cumulative baseline hazard, adjusted survival probabilities and predicted survival probabilities are calculated.}

\item{pre.t}{Vector of pre-specified time points at which the standard errors of the cumulative baseline hazard, adjusted survival probabilities and predicted survival probabilities are calculated. 
By default these are the time points where main event occurs.}

\item{Z0}{Vector of covariates at which predicted survival probabilities are calculated. By default this vector is a zero vector.}
}
\value{
Returns a list with the following components. If \code{est.t=FALSE} then only upto
$nstrata are provided.
\item{$coef}{Parameter estimates}
\item{$p.value}{p-value of regression coefficients}
\item{$var}{Covariance matrix of parameter estimates calculated based on sandwich type variance}
\item{$infor}{Information matrix}
\item{$loglikelihood}{Maximum log-likelihood value}
\item{$n}{Total number of observations used}
\item{$nevents}{Total number of events and censored observations}
\item{$nclusters}{Total number of clusters}
\item{$nstrata}{Total number of treatment groups}
\item{$CumBaseHaz.t}{Cumlative baseline hazard estimates and their standard errors}
\item{$Spredict.t}{Predicted survival probabilities and their standard errors}
\item{$AdjustedS.t}{Adjusted survival probabilities and their standard errors}
\item{$Adjusted.se.diff}{Standard error of the difference of adjusted survival probabilities between the treatment groups}
}
\description{
Stratified marginal proportional hazards model for clustered survival data.
The estimates of the cumulative baseline hazard along with their standard errors are provided at the
pre-specified time points.
Furthermore, the estimated adjusted survival probabilities along with their standard errors are calculated at pre-specified time points. The standard errors of the
difference in estimated adjusted survival probabilities between the groups are also provided.
Finally, the estimates of survival probabilities given vector \code{Z0} along with their standard errors are provided at
pre-specified time points. Tied data are handled by adding a tiny random shift from a normal distribution with mean 0 and standard deviation
1e-09.
}
\examples{
#Simulated data 
alpha = 0.5
d = simulate_surv_data(N=100,alpha=alpha,beta1=0.5*1/alpha,beta2=-0.5*1/alpha,
beta3=1/alpha,rateC=1.3,lambda0=1,lambda1=2,stratified = TRUE)

#Stratified Model with est.t=TRUE
model1 <- survCOX(times=d$times,deltas=d$delta,covariates=d[,5:7],treatment=d[,8],
clusters=d$cluster,est.t=TRUE,pre.t=sort(d$times[d$delta==1]),Z0=c(1,0.5,1) )

#Unstratified Model with est.t=TRUE
model2 <- survCOX(times=d$times,deltas=d$delta,covariates=d[,5:7],treatment=d[,8],
clusters=d$cluster,est.t=TRUE,pre.t=sort(d$times[d$delta==1]),stratified.model=FALSE,
Z0=c(1,0.5,1) )

#Stratified Model with est.t=FALSE
model3 <- survCOX(times=d$times,deltas=d$delta,covariates=d[,5:7],treatment=d[,8],
clusters=d$cluster,est.t=FALSE,pre.t=sort(d$times[d$delta==1]),Z0=c(1,0.5,1) )

#Unstratified Model with est.t=FALSE
model4 <- survCOX(times=d$times,deltas=d$delta,covariates=cbind(d[,5:7],d[,8]),
clusters=d$cluster,est.t=FALSE,pre.t=sort(d$times[d$delta==1]),
stratified.model=FALSE,Z0=c(1,0.5,1) )

#Only continuous covariates are available
model5 <- survCOX(times=d$times,deltas=d$delta,covariates=d[,5:7],
clusters=d$cluster,est.t=FALSE,pre.t=sort(d$times[d$delta==1]),
stratified.model=FALSE,Z0=c(1,0.5,1) )
}
