% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{nv_neuro}
\alias{nv_neuro}
\title{Nervous System Findings Dataset}
\format{
A data frame with 20 columns:
\describe{
\item{STUDYID}{Study Identifier}
\item{DOMAIN}{Domain Abbreviation}
\item{USUBJID}{Unique Subject Identifier}
\item{NVSEQ}{Sequence Number}
\item{NVLNKID}{Link ID}
\item{NVTESTCD}{Short Name of Nervous System Test}
\item{NVTEST}{Name of Nervous System Test}
\item{NVCAT}{Category for Nervous System Test}
\item{NVLOC}{Location Used for the Measurement}
\item{NVMETHOD}{Method of Test or Examination}
\item{NVNAM}{Vendor Name}
\item{NVORRES}{Result or Finding in Original Units}
\item{NVORRESU}{Original Units}
\item{NVSTRESC}{Character Result/Finding in Std Format}
\item{NVSTRESN}{Numeric Result/Finding in Standard Units}
\item{NVSTRESU}{Standard Units}
\item{VISITNUM}{Visit Number}
\item{VISIT}{Visit Name}
\item{NVDTC}{Date/Time of Collection}
\item{NVDY}{Study Day of Collection}
\item{NVLOBXFL}{Last Observation Before Exposure Flag}
}
}
\source{
Constructed using \code{dm_neuro} from \code{{admiralneuro}} package for USUBJID and cohort information, \code{vs} from \code{{pharmaversesdtm}} for visit schedule such as VISIT, NVDTC, NVDY
}
\usage{
nv_neuro
}
\description{
A SDTM NV domain dataset containing nervous system findings and measurements
}
\details{
Nervous System Findings Dataset

A SDTM NV domain dataset for Alzheimer's disease observational and interventional studies, including amyloid and tau PET data at baseline and two follow-up visits reflect levels of pathology appropriate for disease or treatment course
}
\seealso{
Other datasets: 
\code{\link{admiralneuro_adapet}},
\code{\link{admiralneuro_adtpet}},
\code{\link{adsl_neuro}},
\code{\link{ag_neuro}},
\code{\link{dm_neuro}},
\code{\link{suppnv_neuro}}
}
\concept{datasets}
\keyword{datasets}
