% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tp_to_adm.R
\name{tp_to_adm}
\alias{tp_to_adm}
\title{Construct age-depth model from tie points}
\usage{
tp_to_adm(t, h, T_unit = NULL, L_unit = NULL)
}
\arguments{
\item{t}{Vector, tie points in time}

\item{h}{Vector, tie points in height}

\item{T_unit}{character, time unit}

\item{L_unit}{character, length unit}
}
\value{
object of class \code{adm}
}
\description{
Turns tie points into an \code{adm} object that represents an age-depth model
}
\details{
by default, intervals with no sediment accumulation are marked as destructive.
\code{tp_to_adm} does not check whether the inputs define a valid age-depth model. For this, use
\code{is_adm}
}
\examples{

my_adm = tp_to_adm(t = 1:4, h = c(1,2,2,3), T_unit = "kyr", L_unit = "m")
plot(my_adm)
# see vignette("admtools") for other examples

 

}
\seealso{
\code{\link[=is_adm]{is_adm()}} to check validity of \code{adm} objects, \code{\link[=get_T_tp]{get_T_tp()}} and \code{\link[=get_L_tp]{get_L_tp()}} to extract time and height/length tie points
}
