% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{plot_uncertainties}
\alias{plot_uncertainties}
\title{Plot MLE vs MCMC marginal standard deviations for each
parameter}
\usage{
plot_uncertainties(fit, log = TRUE, plot = TRUE)
}
\arguments{
\item{fit}{A fitted object returned by
\code{\link{sample_admb}}}

\item{log}{Whether to plot the logarithm or not.}

\item{plot}{Whether to plot it or not.}
}
\value{
Invisibly returns data.frame with parameter name and
  estimated uncertainties.
}
\description{
Plot MLE vs MCMC marginal standard deviations for each
parameter
}
\details{
It can be helpful to compare uncertainty estimates
  between the two paradigms. This plots the marginal posterior
  standard deviation vs the frequentist standard error
  estimated from the .cor file. Large differences often
  indicate issues with one estimation method.
}
\examples{
fit <- readRDS(system.file('examples', 'fit.RDS', package='adnuts'))
x <- plot_uncertainties(fit, plot=FALSE)
head(x)
}
