% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cm_function.R
\name{cm_function}
\alias{cm_function}
\title{Create A Calculated Metric Function}
\usage{
cm_function(
  func = "col-sum",
  metric = "visits",
  dimension = NULL,
  seg_filter = NULL,
  rsid = Sys.getenv("AW_REPORTSUITE_ID"),
  company_id = Sys.getenv("AW_COMPANY_ID")
)
}
\arguments{
\item{func}{Calculated function id. Only Basic single metric functions are able to be used.}

\item{metric}{The metric to be used in the functional metric calculation. Default is \code{visits}}

\item{dimension}{The dimension to be used in the functional metric calculation. Default is \code{NULL}}

\item{seg_filter}{A segment filter to be added to a metric in the formula}

\item{rsid}{Adobe report suite ID (RSID).  If an environment variable called
\code{AW_REPORTSUITE_ID} exists in \code{.Renviron} or elsewhere and no \code{rsid} argument
is provided, then the \code{AW_REPORTSUITE_ID} value will be used. Use \code{\link[=aw_get_reportsuites]{aw_get_reportsuites()}}
to get a list of available \code{rsid} values.}

\item{company_id}{Company ID. If an environment variable called \code{AW_COMPANY_ID}
exists in \code{.Renviron} or elsewhere and no \code{company_id} argument is provided,
then the \code{AW_COMPANY_ID} value will be used. Use \code{\link[=get_me]{get_me()}} to get a list of
available \code{company_id} values.}
}
\value{
Returns a full list of calculated metric functions or a specified function that the user can access.
}
\description{
Returns a JSON string defining a function to be used to build a calculated (derived) metric.
}
