% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Udplotfnc.R
\name{udplot}
\alias{udplot}
\title{Creates Ud-plot for the provided data excluding and including the estimated normal density curve.}
\usage{
udplot(X, npdf = FALSE, title = ifelse(npdf == FALSE, "Ud-plot",
       "Ud-plot & Normal Density Curve"), xlab = "x", lcol = "black",
       rcol = "grey60", pdfcol = "red", ...)
}
\arguments{
\item{X}{an \eqn{n} by \eqn{1} matrix, equivalently, a column vector of length \eqn{n}, where \eqn{n} is the number of observations.}

\item{npdf}{display of the estimated normal density curve in the Ud-plot, \emph{FALSE} by default.}

\item{title}{title of the plot, \emph{Ud-plot} by default and \emph{Ud-plot & Normal Density Curve} otherwise.}

\item{xlab}{\eqn{x}-axis label, \eqn{x} by default.}

\item{lcol}{color of the points corresponding to the data that are less than or equal to the sample average, \emph{black} by default.}

\item{rcol}{color of the points corresponding to the data that are greater than the sample average, \emph{grey60} by default.}

\item{pdfcol}{color of the estimated normal density curve, \emph{red} by default.}

\item{...}{other graphical parameters.}
}
\value{
Ad-plot
}
\description{
Ud-plot developed by a slight modification of Ad-plot can be utilized to assess normality.
}
\examples{
   set.seed(0)
   X1 <- matrix(rnorm(50, mean = 2, sd = 5))
   udplot(X1)

   X2 <- matrix(rnorm(50, mean = 2, sd = 5))
   udplot(X2, npdf = TRUE)

   X3 <- matrix(rnorm(500, mean = 2, sd = 5))
   udplot(X3, npdf = TRUE, title = "", lcol = "blue", rcol = "red", pdfcol = "black")
}
\references{
Wijesuriya, U. A. (2025). Ad-plot and Ud-plot for Determining Distributional
            Characteristics and Normality.
            \emph{Communications in Statistics-Theory and Methods}, \doi{10.1080/03610926.2024.2440583}.
}
