% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aftR2.R
\name{aftR2}
\alias{aftR2}
\title{R-squared measure under the accelerated failure time (AFT) models.}
\usage{
aftR2(fit.AFT)
}
\arguments{
\item{fit.AFT}{The fitted AFT model from the survival::survreg function}
}
\value{
The R-squared measure
}
\description{
Compute the R-squared measure under the accelerated failure time (AFT) models proposed in the Chan et. al (2018) paper (DOI: 10.1080/03610918.2016.1177072).
}
\examples{
library(survival)
fit.AFT = survreg(Surv(futime, fustat) ~ ecog.ps + rx, ovarian, dist='weibull')
aftR2(fit.AFT)
}
