% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_counts.R
\name{calculate_counts}
\alias{calculate_counts}
\title{calculate_counts}
\usage{
calculate_counts(raw, epoch, lfe_select = FALSE, tz = "UTC", verbose = FALSE)
}
\arguments{
\item{raw}{data frame of raw acceleration data obtained from
\code{\link[read.gt3x]{read.gt3x}}}

\item{epoch}{The epoch length for which the counts should be summed.}

\item{lfe_select}{Apply the Actigraph Low Frequency Extension filter, Default: FALSE}

\item{tz}{the desired timezone, Default: \code{UTC}}

\item{verbose}{Print the progress of the Actigraph raw data conversion to counts, Default: FALSE.}
}
\value{
Returns a data.frame containing the ActiGraph count values
}
\description{
Calculate ActiGraph activity counts from raw acceleration data
    by passing in a data frame with a time stamp, X, Y, and Z axis. This function
    allows the ability to work with the raw data from other files, but the data
    frame needs to have "start_time" and "stop_time" attributes. This is different
    from the \code{\link{get_counts}} function because it reads a raw
    data frame rather than a path name to a GT3X file.
}
\examples{
    f <- system.file("extdata/example.gt3x", package = "agcounts")
    d <- read.gt3x::read.gt3x(f, asDataFrame = TRUE, imputeZeroes = TRUE)
    calculate_counts(d, 60)
}
