% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReasoningWAgg.R
\name{ReasoningWAgg}
\alias{ReasoningWAgg}
\title{Aggregation Method: ReasoningWAgg}
\usage{
ReasoningWAgg(
  expert_judgements,
  reasons = NULL,
  type = "ReasonWAgg",
  name = NULL,
  beta_transform = FALSE,
  beta_param = c(6, 6),
  placeholder = FALSE,
  percent_toggle = FALSE,
  flag_loarmean = FALSE,
  round_2_filter = TRUE
)
}
\arguments{
\item{expert_judgements}{A dataframe in the format of \link{data_ratings}.}

\item{reasons}{A dataframe in the form of \link{data_supp_reasons}}

\item{type}{One of \code{"ReasonWAgg"}, \code{"ReasonWAgg2"}.}

\item{name}{Name for aggregation method. Defaults to \code{type} unless specified.}

\item{beta_transform}{Toggle switch to extremise confidence scores with the beta distribution. Defaults to \code{FALSE}.}

\item{beta_param}{Length two vector of alpha and beta parameters of the beta distribution. Defaults to \code{c(6,6)}.}

\item{placeholder}{Toggle the output of the aggregation method to impute placeholder data.}

\item{percent_toggle}{Change the values to probabilities. Default is \code{FALSE}.}

\item{flag_loarmean}{A toggle to impute LOArMean instead of ArMean when no participants have a reasoning weight for a specific claim (defaults \code{FALSE}).}

\item{round_2_filter}{Note that the IDEA protocol results in both a Round 1
and Round 2 set of probabilities for each claim. Unless otherwise specified,
we will assume that the final Round 2 responses (after discussion) are being
referred to.}
}
\value{
A tibble of confidence scores \code{cs} for each \code{paper_id}.
}
\description{
Calculate one of several types of linear-weighted best estimates using supplementary
participant reasoning data to create weights.
}
\details{
Weighted by the breadth of reasoning provided to support the individuals’ estimate.

\code{type} may be one of the following:

\loadmathjax
\strong{ReasonWAgg}: Weighted by the number of supporting reasons

Giving greater weight to best estimates that are accompanied by a greater number of
supporting reasons may be beneficial. We will consider \mjeqn{w\_{reason}_{i,c}}{ascii}
to be the number of unique reasons provided by that individual \mjeqn{i}{ascii} in
support of their estimate for claim \mjeqn{c}{ascii}.

\mjdeqn{\hat{p}_c(ReasonWAgg) = \sum_{i=1}^N \tilde{w}\_reason_{i,c}B_{i,c}}{ascii}

See Hanea et al. (2021) for an example of reason coding.

\strong{ReasonWAgg2}: Incorporates both the number of reasons and their diversity across claims.

The claim diversity component of this score is calculated per individual from all claims
they assessed. We assume each individual answers at least two claims. If an individual has
assessed only one claim, there weighting for that claim is equivalent to "ReasonWAgg".

We will consider \mjeqn{w\_{varReason}_{i,c}}{ascii} to be the weighted "number of unique
reasons" provided by participant \mjeqn{i}{ascii} in support of their estimate for claim
\mjeqn{c}{ascii}. Assume there are \mjeqn{R}{ascii} total unique reasons any participant
can use to justify their numerical answers. Then, for each participant \mjeqn{i}{ascii} we
can construct a matrix \mjeqn{\mathbf{CR_i}}{ascii} with \mjeqn{R}{ascii} columns, each
corresponding to a unique reason, \mjeqn{r}{ascii}, and \mjeqn{C}{ascii} rows, where
\mjeqn{C}{ascii} is the number of claims assessed by that participant. Each element of
this matrix \mjeqn{\mathbf{CR_i}(r,c)}{ascii} can be either 1 or 0.
\mjeqn{\mathbf{CR_i}(r,c) = 1}{ascii} if reason \mjeqn{R_r}{ascii} was used to justify
the estimates assessed for \mjeqn{c}{ascii}, and \mjeqn{\mathbf{CR_i}(r,c) = 0}{ascii} if
reason \mjeqn{R_r}{ascii} was not mentioned when assessing claim \mjeqn{c}{ascii}. The
more frequently that a participant uses a given reason reduces the amount it contributes
to the weight assigned to that participant.

\mjdeqn{w\_{varReason}_{i,c} =\sum_{r=1}^{R} \mathbf{CR_i}(c,r) \cdot (1 - \frac{\sum_{c=1}^C
\mathbf{CR_i}(c,r)}{C})}{ascii}

\mjdeqn{\hat{p}_c(ReasonWAgg2) = \sum_{i=1}^N \tilde{w}\_varReason_{i,c}B_{i,c}}{ascii}
}
\note{
When \code{flag_loarmean} is set to \code{TRUE}, two additional columns will be returned; \code{method_applied} (a character variable describing the method actually applied with values of either \code{LoArMean} or \code{ReasonWAgg}) and \code{no_reason_score} (a logical variable describing whether no reasoning scores were supplied for any user for the given claim, where \code{TRUE} indicates no reasoning scores supplied and \code{FALSE} indicates that at least one participant for that claim had a reasoning score greater than 0).

named method_applied (with values LoArMean or ReasonWAgg), and no_reason_score, a logical variable describing whether or not there were no reasoning scores for that claim.
}
\examples{
\donttest{ReasoningWAgg(data_ratings)}

}
