% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weight_nIndivInterval.R
\name{weight_nIndivInterval}
\alias{weight_nIndivInterval}
\title{Weighting method: Individually scaled interval widths}
\usage{
weight_nIndivInterval(expert_judgements)
}
\arguments{
\item{expert_judgements}{A dataframe in the form of \link{data_ratings}}
}
\value{
A tibble in the form of the input \code{expert_judgements} argument with additional columns
supplying the calculated weight for each row's observation.
}
\description{
Weighted by the rescaled interval width within individuals across claims.
}
\details{
\loadmathjax
This function is used inside \link{IntervalWAgg} for aggregation types \code{"IndIntWAgg"},
\code{"IndIntAsymWAgg"} and \code{"KitchSinkWAgg"}. Interval width weights are rescaled
relative to an individuals interval widths across all claims.

\mjdeqn{w\_nIndivInterval_{i,c} = \frac{1}{\frac{U_{i,c}-L_{i,c}}{\max\left(\{(U_{i,d}-L_{i,d}):d=1,...,C\}\right)}}}{ascii}
}
