/* ************************************************************************* *
 * This file is part of the 'agop' library.                                  *
 *                                                                           *
 * Copyleft (c) 2013-2023, Marek Gagolewski <https://www.gagolewski.com/>    *
 *                                                                           *
 *                                                                           *
 * 'agop' is free software: you can redistribute it and/or modify it under   *
 * the terms of the GNU Lesser General Public License as published by        *
 * the Free Software Foundation, either version 3 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * 'agop' is distributed in the hope that it will be useful,                 *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the              *
 * GNU Lesser General Public License for more details.                       *
 *                                                                           *
 * A copy of the GNU Lesser General Public License can be downloaded         *
 * from <http://www.gnu.org/licenses/>.                                      *
 * ************************************************************************* */

#include "agop.h"




#define MAKE_CALL_METHOD(name, args) \
   {#name, (DL_FUNC)(void (*) (void))(&name), args}




/**
 * List of functions available in R via .Call()
 *
 * Form:
 * \code{\{"method_name", (DL_FUNC)pointer, number_of_args\}} -
 * this is generated by the MAKE_CALL_METHOD macro.
 */
static const R_CallMethodDef cCallMethods[] = {

   MAKE_CALL_METHOD(owa,                        2),
   MAKE_CALL_METHOD(wam,                        2),
   MAKE_CALL_METHOD(wmax,                       2),
   MAKE_CALL_METHOD(wmin,                       2),
   MAKE_CALL_METHOD(owmax,                      2),
   MAKE_CALL_METHOD(owmin,                      2),
   MAKE_CALL_METHOD(index_h,                    1),
   MAKE_CALL_METHOD(index_g,                    1),
   MAKE_CALL_METHOD(index_g_zi,                 1),
   MAKE_CALL_METHOD(index_maxprod,              1),
   MAKE_CALL_METHOD(index_w,                    1),
   MAKE_CALL_METHOD(index_rp,                   2),
   MAKE_CALL_METHOD(index_lp,                   2),
   MAKE_CALL_METHOD(d2owa_checkwts,             1),

   MAKE_CALL_METHOD(check_comonotonicity,       3),
   MAKE_CALL_METHOD(pord_weakdom,               2),
   MAKE_CALL_METHOD(pord_nd,                    3),
   MAKE_CALL_METHOD(pord_spread,                3),

   MAKE_CALL_METHOD(rel_is_cyclic,              1),

   MAKE_CALL_METHOD(rel_is_irreflexive,         1),

   MAKE_CALL_METHOD(rel_is_asymmetric,          1),

   MAKE_CALL_METHOD(rel_is_antisymmetric,       1),

   MAKE_CALL_METHOD(rel_is_transitive,          1),
   MAKE_CALL_METHOD(rel_closure_transitive,     1),
   MAKE_CALL_METHOD(rel_reduction_transitive,   1),

   MAKE_CALL_METHOD(rel_reduction_hasse,        1),

   MAKE_CALL_METHOD(rel_is_reflexive,           1),
   MAKE_CALL_METHOD(rel_closure_reflexive,      1),
   MAKE_CALL_METHOD(rel_reduction_reflexive,    1),

   MAKE_CALL_METHOD(rel_is_total,               1),
   MAKE_CALL_METHOD(rel_closure_total_fair,     1),

   MAKE_CALL_METHOD(rel_is_symmetric,           1),
   MAKE_CALL_METHOD(rel_closure_symmetric,      1),

   MAKE_CALL_METHOD(exp_test_statistic,         1),
   MAKE_CALL_METHOD(ppareto2,                   4),

   MAKE_CALL_METHOD(tnorm_minimum,              2),
   MAKE_CALL_METHOD(tnorm_product,              2),
   MAKE_CALL_METHOD(tnorm_lukasiewicz,          2),
   MAKE_CALL_METHOD(tnorm_drastic,              2),
   MAKE_CALL_METHOD(tnorm_fodor,                2),

   MAKE_CALL_METHOD(tconorm_minimum,            2),
   MAKE_CALL_METHOD(tconorm_product,            2),
   MAKE_CALL_METHOD(tconorm_lukasiewicz,        2),
   MAKE_CALL_METHOD(tconorm_drastic,            2),
   MAKE_CALL_METHOD(tconorm_fodor,              2),

   MAKE_CALL_METHOD(fnegation_classic,          1),
   MAKE_CALL_METHOD(fnegation_yager,            1),
   MAKE_CALL_METHOD(fnegation_minimal,          1),
   MAKE_CALL_METHOD(fnegation_maximal,          1),

   MAKE_CALL_METHOD(fimplication_maximal,       2),
   MAKE_CALL_METHOD(fimplication_minimal,       2),
   MAKE_CALL_METHOD(fimplication_kleene,        2),
   MAKE_CALL_METHOD(fimplication_lukasiewicz,   2),
   MAKE_CALL_METHOD(fimplication_reichenbach,   2),
   MAKE_CALL_METHOD(fimplication_fodor,         2),
   MAKE_CALL_METHOD(fimplication_goguen,        2),
   MAKE_CALL_METHOD(fimplication_goedel,        2),
   MAKE_CALL_METHOD(fimplication_rescher,       2),
   MAKE_CALL_METHOD(fimplication_weber,         2),
   MAKE_CALL_METHOD(fimplication_yager,         2),

   // the list must be NULL-terminated:
   {NULL,                           NULL,       0}
};


extern "C" void R_init_agop(DllInfo *dll)
{
   R_registerRoutines(dll, NULL, cCallMethods, NULL, NULL);
   R_useDynamicSymbols(dll, Rboolean(FALSE));
}
