% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/erNeeded.R
\name{erNeeded}
\alias{erNeeded}
\title{Baseline event rate needed (fixed sample size)}
\usage{
erNeeded(
  N,
  bta1,
  thta,
  tau,
  alp = 0.05,
  pow = 0.8,
  ar = 0.5,
  lam0warning = FALSE
)
}
\arguments{
\item{N}{Sample size.}

\item{bta1}{log-transform of rate ratio.}

\item{thta}{Variance of frailty parameter.}

\item{tau}{Expected follow-up time.}

\item{alp}{Two-sided alpha-level.}

\item{pow}{Target power.}

\item{ar}{Allocation ratio (Number control / Total).}

\item{lam0warning}{If TRUE indicates how many estimates of lam0 were negative before setting to Inf. Default FALSE.}
}
\value{
The baseline event rate needed to achieve target power at one-sided Type I control level alpha/2, given the input assumptions.
}
\description{
Function to compute baseline (control) event rate needed to achieve given power at one-sided Type I control level alp/2.
}
\details{
Assumes rate ratio < 1 is favourable to treatment.
A negative estimated event rate indicates no event rate is sufficient under the input assumptions.
}
\examples{

erNeeded(N = 500, bta1 = log(0.6), thta = 2, tau = 1, alp = 0.05, pow = 0.8)
erNeeded(N = 500, bta1 = log(0.6), thta = 3, tau = 1, alp = 0.05, pow = 0.8)


if (require("dplyr") & require("tidyr")) {

  assumptions = tibble(alp = 0.05) \%>\%
  crossing(
    tau = c(0.8,0.9, 1.0),
    RR = c(0.6, 0.7, 0.8),
    thta = c(2, 3, 4),
    pow = 0.8,
    N = c(500, 1000)
  ) \%>\%
    mutate(er = erNeeded(N = N, bta1 = log(RR), thta = thta, tau = tau, alp, pow))

  assumptions \%>\% data.frame()

}

}
