% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prodata.R
\name{prodata}
\alias{prodata}
\title{Data processing}
\usage{
prodata(data, status_colname, SplitRatio = 0.75)
}
\arguments{
\item{data}{data.frame with data to be modeled}

\item{status_colname}{name of the column in data where the true results (true positive, expected) values are listed}

\item{SplitRatio}{Splitting ratio; 0.75 means 75\% data for training and 25\% for testing, more: \link[caTools]{sample.split}}
}
\value{
data list
}
\description{
The \code{prodata} function generates an data list for models. It additionally splits data for training and testing set by split ratio.
}
\examples{
\donttest{

model_data <- data.frame(a = c(1,2,3,4,5,6),
                         b = c(1,2,3,4,5,6),
                         s = c(1,2,3,4,5,6))

prodata(data = model_data, status_colname = "s")

}

}
