% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreateRunOptions.GRiwrmInputsModel.R,
%   R/CreateRunOptions.R
\name{CreateRunOptions.GRiwrmInputsModel}
\alias{CreateRunOptions.GRiwrmInputsModel}
\alias{CreateRunOptions}
\alias{CreateRunOptions.InputsModel}
\alias{CreateRunOptions.character}
\alias{CreateRunOptions.function}
\title{Creation of the RunOptions object}
\usage{
\method{CreateRunOptions}{GRiwrmInputsModel}(x, IniStates = NULL, ...)

CreateRunOptions(x, ...)

\method{CreateRunOptions}{InputsModel}(x, ...)

\method{CreateRunOptions}{character}(x, InputsModel, ...)

\method{CreateRunOptions}{`function`}(x, InputsModel, ...)
}
\arguments{
\item{x}{For a single catchment, it can be an object of class \emph{InputsModel} or a \link{function} or a \link{character} corresponding to \code{FUN_MOD} (compliant with \strong{airGR} call). For a network, it should be an object of class \emph{GRiwrmInputsModel}. See \link{CreateInputsModel} for details}

\item{IniStates}{(optional) \link{numeric} object or \link{list} of \link{numeric} object of class \emph{IniStates}, see \link[airGR:CreateIniStates]{airGR::CreateIniStates} for details}

\item{...}{arguments passed to \link[airGR:CreateRunOptions]{airGR::CreateRunOptions}, see details}

\item{InputsModel}{object of class \emph{InputsModel} (only used to be consistent
with the original \link[airGR:CreateRunOptions]{airGR::CreateRunOptions} which has \code{FUN_MOD} as first
parameter)
see \link[airGR:CreateInputsModel]{airGR::CreateInputsModel} for details}
}
\value{
Depending on the class of \code{InputsModel} argument (respectively
\emph{InputsModel} and \emph{GRiwrmInputsModel} object), the returned value is respectively:
\itemize{
\item a \code{RunOptions} object (See \link[airGR:CreateRunOptions]{airGR::CreateRunOptions})
\item a \code{GRiwrmRunOptions} object which is a \link{list} of \code{RunOptions} objects with one item per modeled sub-catchment
}
}
\description{
This function can be used either for a catchment (with an \emph{InputsModel} object) or for a network (with a \emph{GRiwrmInputsModel} object)
}
\details{
See \link[airGR:CreateRunOptions]{airGR::CreateRunOptions} documentation for a complete list of arguments.

If \code{x} argument is a \emph{GRiwrmInputsModel} object, \code{IniStates} must be a
list of \link{numeric} object of class \emph{IniStates} with one item per modeled sub-catchment.

With a \emph{GRiwrmInputsModel} object, all arguments are applied on each
sub-catchments of the network.

For examples of use see topics \link{RunModel.GRiwrmInputsModel}, \link{RunModel_Reservoir},
and \link{RunModel.Supervisor}.
}
\seealso{
\code{\link[=CreateGRiwrm]{CreateGRiwrm()}}, \code{\link[=CreateInputsModel.GRiwrm]{CreateInputsModel.GRiwrm()}}, \code{\link[=RunModel.GRiwrmInputsModel]{RunModel.GRiwrmInputsModel()}}
}
