% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assess_thrombocytopenia.R
\name{assess_thrombocytopenia}
\alias{assess_thrombocytopenia}
\title{Assess hematological toxicities : Thrombocytopenia}
\usage{
assess_thrombocytopenia(input_files_path, plt_range, duration_plt = NA)
}
\arguments{
\item{input_files_path}{path to a file or a folder with MT csv files (in quotes).}

\item{plt_range}{Platelet (PLT) value range of c(thrombocytopenic PLT threshold, recovered PLT threshold). NOTE: Ensure that units are the same as unit of PLT in the input data.}

\item{duration_plt}{numeric duration (in weeks) that is used to categorize event as "long duration thrombocytopenia" (optional)}
}
\value{
Returns a list with (1) the thrombocytopenia information for each patient as listed below,
(2) analysis summary as dataframe (3) analysis summary as HTML table.
\enumerate{
\item{Pat ID}
\item{Number of particular toxicity episodes}
\item{Duration of particular toxicity (in weeks)}
\item{Number of long duration toxicity episodes}
\item{Duration of long duration toxicity (in weeks)}
}
}
\description{
Evaluate number of thrombocytopenia episodes and their duration for a given patient or cohort
}
\note{
\enumerate{
\item{If the function is used for cohort analysis then values are represented as median and interquartile range (IQR) (25\%-75\%). The median and IQR is rounded off to upper integer value if decimal value is greater or equal to 0.5, else to lower integer value. Example 1.4->1 and 3.75->4}
\item{Long duration toxicity is only analyzed if "duration_plt" is included in provided arguments}
\item{User may save the result as a list, if required, to analyze each patient thrombocytopenia analysis by analyzing 1st element of list}
}
}
\examples{
pat_data = system.file("extdata/processed_data/", "UPN_914.csv", package = "allMT")
assess_thrombocytopenia(input_files_path = pat_data,
                      plt_range = c(50, 75), duration_plt = 3)

\donttest{
cohort_path = paste0(system.file("extdata/processed_data/", package = "allMT"), "/")
assess_thrombocytopenia(input_files_path = cohort_path,
                      plt_range = c(50, 75), duration_plt = 3)


result <- assess_thrombocytopenia(input_files_path = pat_data,
                      plt_range = c(0.5, 0.75), duration_plt = 3)
print(result[[1]])
print(result[[2]])
print(result[[3]])
}

}
\seealso{
\code{\link[=assess_neutropenia]{assess_neutropenia()}}, \code{\link[=assess_anemia]{assess_anemia()}}
}
