% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split.R
\name{summary.split_df}
\alias{summary.split_df}
\title{Summarizing split_df information}
\usage{
\method{summary}{split_df}(object, ...)
}
\arguments{
\item{object}{an object of class "split_df", usually, a result of a call to split_df().}

\item{...}{further arguments passed to or from other methods.}
}
\value{
NULL is returned. 
However, the split train set and test set information are displayed. The output information is as follows.:

\itemize{
\item Random seed
\item Number of train sets and test sets
\item Name of target variable
\item Target variable minority class and majority class information (label and ratio)
}
}
\description{
summary method for "split_df" class.
}
\details{
summary.split_df provides information on the number of two split data sets, minority class and majority class.
}
\examples{
library(dplyr)

# Credit Card Default Data
head(ISLR::Default)

# Generate data for the example
sb <- ISLR::Default \%>\%
  split_by(default)

sb
summary(sb)

}
