% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test.control.R
\name{test.control}
\alias{test.control}
\title{Control function for the adaptive norm test}
\usage{
test.control(
  n_peld_mc_samples = 300,
  nrm_type = "lp",
  perf_meas = "est_acc",
  pos_lp_norms = c(1, 2, 3, "max"),
  ld_est_meth = "par_boot",
  ts_ld_bs_samp = 250,
  other_output = c(),
  ...
)
}
\arguments{
\item{n_peld_mc_samples}{Number of samples to be used in approximating the
estimated limiting distribution of the parameter estimate under the null.
Increasing this value reduces the approximation error of the test statistic.}

\item{nrm_type}{The type of norm to be used for the test.
Generally the l_p norm}

\item{perf_meas}{the preferred measure used to generate the test statistic.}

\item{pos_lp_norms}{The index of the norms to be considered.  For example if
we use the l_p norm, norms_indx specifies the different p's to try.}

\item{ld_est_meth}{String indicating method for estimating the limiting
distribution of the test statistic parametric bootstrap or permutation.}

\item{ts_ld_bs_samp}{The number of test statistic limiting distribution
bootstrap samples to be drawn.}

\item{other_output}{A vector indicating additional data that should be
returned. Currently only \code{"var_est"} and \code{data} is supported.}

\item{...}{Other arguments needed in other places.}
}
\value{
A list that provide controls for \code{mv_pn_test} (specified by the
arguments passed to \code{test.control}).
}
\description{
Control function for the adaptive norm test
}
\examples{
test.control()

}
