% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spaces.R
\name{space_download}
\alias{space_download}
\title{Upload a directory to an existing Space}
\usage{
space_download(
  name,
  local = NULL,
  remote = NULL,
  spaces_region = NULL,
  spaces_key = NULL,
  spaces_secret = NULL,
  ...
)
}
\arguments{
\item{name}{(character) The name of the existing Space}

\item{local}{(character) The name of the local directory}

\item{remote}{(character) The name of the remote directory}

\item{spaces_region}{(character) String containing a spaces region. If
missing, defaults to value stored in an environment variable
\code{DO_SPACES_REGION}.}

\item{spaces_key}{(character) String containing a spaces access key. If
missing, defaults to value stored in an environment variable
\code{DO_SPACES_ACCESS_KEY}.}

\item{spaces_secret}{(character) String containing the secret associated
with the spaces key. If missing, defaults to value stored in an environment
variable \code{DO_SPACES_SECRET_KEY}.}

\item{...}{Additional arguments to \code{arrow::copy_files}}
}
\value{
(character) Success/error message.
}
\description{
Upload a directory to an existing Space
}
\examples{
\dontrun{
# Upload to an existing Space
# (Check names within region)
space_download("my_space", "my_subdir", "my_subdir", "nyc3",
 spaces_key = Sys.getenv("SPACES_KEY"),
 spaces_secret = Sys.getenv("SPACES_SECRET"))
}
}
