% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CQassociation.R
\name{CQassociation}
\alias{CQassociation}
\title{Association (Correlation) between Continuous-Categorical Variables}
\usage{
CQassociation(
  numtb,
  factb,
  method3 = c("auto", "parametric", "non-parametric"),
  use = "everything",
  normality_test_method = c("ks", "anderson", "shapiro"),
  normality_test_pval,
  methodMat3 = NULL,
  methods_used
)
}
\arguments{
\item{numtb}{a data frame with all the numerical columns. This should
have at least two columns}

\item{factb}{a data frame with all the categorical columns. This should
have atleast two columns}

\item{method3}{method for association between continuous-categorical
variables. Values can be \code{"auto", "parametric", "non-parametric"}.
See details for more information. Parametric does t-test while
non-parametric does 'Mann-Whitney’ test.}

\item{use}{an optional character string giving a method for computing
association in the presence of missing values. This must be (complete or an
abbreviation of) one of the strings "everything", "all.obs",
"complete.obs", "na.or.complete", or "pairwise.complete.obs". If use is
"everything", NAs will propagate conceptually, i.e., a resulting value will
be NA whenever one of its contributing observations is NA. If use is
"all.obs", then the presence of missing observations will produce an error.
If use is "complete.obs" then missing values are handled by case wise
deletion (and if there are no complete cases, that gives an error).
"na.or.complete" is the same unless there are no complete cases, that gives
NA}

\item{normality_test_method}{takes values as 'shapiro' or 'anderson'.
this parameter decides which test to perform for the normality test.
See details of \code{\link{norm_test_fun}} for more information.}

\item{normality_test_pval}{significance level for normality tests.
Default is 0.05}

\item{methodMat3}{method dataframe like methodMats from the function \code{
association}}

\item{methods_used}{a square data.frame which will store the type of
association used between the variables. Dimension will be
number of variables * number of variables.}
}
\value{
a table with number of rows equal to number of columns in
\code{numtb} and number of columns equal to number of columns in
\code{factb}. Table containing p-values of performed test
}
\description{
\code{CQassociation} finds Association measure between one
categorical and one continuous variable.
}
\details{
This function measures the association between one categorical variable
and one continuous variable present in different dataset. Two datasets
are provided as input, one data has only numerical columns while other
data has only categorical columns. This performs either t-test for the
parametric case and 'Mann-Whitney’ test for the non-parametric case.
If the method3 is passed as 'auto', the function defines the method
itself based on different tests for equal variance and normality check
which checks for assumptions for the t-test. If the assumptions are
satisfied, then t-test (parametric) is performed, otherwise
'Mann-Whitney’ (non-parametric) test is performed.
}
\seealso{
\code{\link{norm_test_fun}} for normality test
\code{\link{association}} for association between any type of variables,
\code{\link{CCassociation}} for Association between Continuous (numeric)
variables,
\code{\link{QQassociation}} for Association between Categorical variables
}
