% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ethical_nl}
\alias{ethical_nl}
\title{Ethical investment decision tree for a fictional company in hierarchical format}
\format{
A nested node list of the ethical investment dataset, in
which hierarchical relationships are indicated by a nested list

\describe{
Each list element represents a node or leaf in the tree and has the
following members:
\item{name}{A short, unique alphanumeric code or name for nodes. For
leaf nodes (questions), a short code is used. For higher nodes, a
descriptive phrase is used.}
\item{rule}{The logical rule for nodes, either \strong{AND} or \strong{OR}, and
NA for leaves.}
\item{question}{(Optional) For leaf nodes, the associated question.}
\item{nodes}{A list of nested nodes}

}
}
\source{
This is a simple hypothetical decision tree created solely to
illustrate the use of the analytical approach.
}
\usage{
ethical_nl
}
\description{
This dataframe represents a decision tree in hierarchical format, in
which hierarchical relationships are indicated by a nested list

The decision tree is a hypothetical tool to standardise the process of
making ethical investments. It was developed to illustrate the functionality
of this package.
}
\details{
A \code{data.tree} object is created from the nested list using the
\code{read_tree_node_list()} function.
}
\examples{
# Read the data into a data.tree object for analysis
tree <- load_tree_node_list(ethical_nl)

# View the tree
print_tree(tree)
}
\keyword{datasets}
