% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/video_processing.R
\name{extract_frames_old}
\alias{extract_frames_old}
\title{Extract frames from video for classification}
\usage{
extract_frames_old(
  files,
  out_dir = tempfile(),
  out_file = NULL,
  fps = NULL,
  frames = NULL,
  file_col = "FilePath",
  parallel = FALSE,
  workers = 1,
  checkpoint = 1000
)
}
\arguments{
\item{files}{dataframe of videos}

\item{out_dir}{directory to save frames to}

\item{out_file}{file to which results will be saved}

\item{fps}{frames per second, otherwise determine mathematically}

\item{frames}{number of frames to sample}

\item{file_col}{string value indexing which column contains file paths}

\item{parallel}{Toggle for parallel processing, defaults to FALSE}

\item{workers}{number of processors to use if parallel, defaults to 1}

\item{checkpoint}{if not parallel, checkpoint ever n files, defaults to 1000}
}
\value{
dataframe of still frames for each video
}
\description{
This function can take
}
\examples{
\dontrun{
frames <- extractFrames(videos, out_dir = "C:\\\\Users\\\\usr\\\\Videos\\\\", frames = 5)
}
}
