% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_aniview.R
\name{use_aniview}
\alias{use_aniview}
\title{Use AniView}
\usage{
use_aniview(animateThreshold = 0, scrollPollInterval = 20)
}
\arguments{
\item{animateThreshold}{integrer. +ve numbers delay the animation sequence until the specified number of pixels have come into view. -ve numbers will trigger the animation sequence prior to the element coming into view.}

\item{scrollPollInterval}{integrer. frequency at which user scrolling is 'polled' i.e. tested. This is in milliseconds and is an extension to jQuery's in-built 'scroll' event/handler.}
}
\description{
Use AniView
}
\examples{
library(shiny)

ui <- function(){
fluidPage(
  use_aniview(), # add use_aniview() in the UI
  aniview(h1("Shiny with AniView"), animation = "fadeInUp"),
  aniview(textOutput("text"), animation = "zoomIn")
)
}

server <- function(input, output, session){
 output$text <- renderText({
   print("An animated text.")
 })
}

if(interactive()) shinyApp(ui, server)

}
