% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/play_file.R
\name{nll_basic_logscale}
\alias{nll_basic_logscale}
\title{Negative log-likelihood function: basic model on logscale}
\usage{
nll_basic_logscale(
  a1 = a1,
  b1 = b1,
  a2 = a2,
  b2 = b2,
  data = data,
  time = time,
  censor = censor,
  infected_treatment = infected_treatment,
  d1 = "Weibull",
  d2 = "Weibull"
)
}
\arguments{
\item{a1, b1}{location and scale parameters for background mortality
on a logscale}

\item{a2, b2}{location and scale parameters for mortality due to infection
on a logscale}

\item{data}{name of data frame containing survival data}

\item{time}{name of data frame column identifying time of event; time > 0}

\item{censor}{name of data frame column identifying if event was death (0) or
right-censoring (1)}

\item{infected_treatment}{name of data frame column identifying if data are
from an infected (1) or uninfected (0) treatment}

\item{d1, d2}{names of probability distributions describing background
mortality and mortality due to infection, respectively; both default to the
Weibull distribution}
}
\description{
Function returning the negative log-likelihood (nll) for the 'basic' relative
survival model, given the functions' parameters and the observed data.
}
\details{
By deafult, this function takes arguments for location and scale parameters
named; a1, b1, a2, b2. These parameters are components of survival functions
describing patterns of background mortality and mortality due to infection.
The particular form of these survival functions depends on the probability
distributions chosen to describe each source of mortality; d1, d2. The
function also takes arguments directing it to the data to be analysed and how
they are labelled; data, time, censor, etc.

The nll returned by the function depends on the numerical values of the
location and scale parameters, which determine how well the likelihood model
describes the observed data. Maximum likelihood estimation functions, e.g.,
\code{mle2} of the package \code{bbmle}, can be used find values of the
location and scale parameters minimising the model's nll. The resulting
maximum likelihood estimates can be used to describe host mortality due to
background mortality and mortality due to infection, including the pathogen's
virulence.

The model assumes all the individuals in the infected population are
infected. It is also assumes infections are homogeneous, i.e., each
infection has the same influence on host survival. Consequently a single
hazard function, with a single pair of values for its location and scale
parameters, can be used to describe the pattern of mortality due to infection
for the infected population as a whole.
}
\examples{
# prepare subset of 'data_blanford'; treatments 'cont' and 'Bb06' of Block 3

  data01 <- subset(data_blanford,
    (data_blanford$block == 3) & (
      (data_blanford$treatment == 'cont') |
         (data_blanford$treatment == 'Bb06')) &
           (data_blanford$day > 0))

 head(data01, 4)

# step #1: 'prep function' linking 'nll_basic' to data
  # and identifying parameters to estimate
    m01_prep_function <- function(a1 = a1, b1 = b1, a2 = a2, b2 = b2){
      nll_basic_logscale(
        a1 = a1, b1 = b1, a2 = a2, b2 = b2,
        data = data01,
        time = t,
        censor = censor,
        infected_treatment = inf,
        d1 = 'Weibull', d2 = 'Weibull')
        }

# step #2: send 'prep_function' to mle2 for maximum likelihood estimation with
        #  starting values specified
    m01 <- mle2(m01_prep_function,
             start = list(a1 = 1, b1 = 1, a2 = 1, b2 = 1)
             )

    summary(m01)

}
