% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nll_functions.R
\name{nll_controls}
\alias{nll_controls}
\title{Negative log-likelihood function: control data only}
\usage{
nll_controls(
  a1 = a1,
  b1 = b1,
  data = data,
  time = time,
  censor = censor,
  d1 = "Weibull"
)
}
\arguments{
\item{a1, b1}{location and scale parameters for background mortality}

\item{data}{name of data frame containing survival data}

\item{time}{name of data frame column identifying time of event; time > 0}

\item{censor}{name of data frame column idenifying if event was death (0) or
right-censoring (1)}

\item{d1}{name of probability distribution describing background
mortality. Choice of; 'Weibull', 'Gumbel', 'Fréchet'; defaults to the
Weibull distribution}
}
\value{
numeric
}
\description{
Function returning negative log-likelihood (nll) for data in a control
treatment.
}
\details{
This function returns the nll based on two parameters, the location and scale parameters
used to describe background mortality.
}
\examples{
# prepare a subset of the Blanford data for analysis
  data01 <- subset(data_blanford,
    (data_blanford$block == 3) &
      (data_blanford$treatment == 'cont') &
        (data_blanford$day > 0))

# check data frame for names of columns
    head(data01)

# step #1: 'prep function' linking 'nll_controls' to data
  # and identifying parameters to estimate
    m01_prep_function <- function(a1 = a1, b1 = b1){
      nll_controls(
        a1 = a1, b1 = b1,
        data = data01,
        time = t,
        censor = censor,
        d1 = 'Weibull'
        )}

# step #2: send 'prep_function' to mle2 for maximum likelihood estimation
  # specifying starting values
    m01 <- mle2(m01_prep_function,
             start = list(a1 = 2, b1 = 0.5)
             )

    summary(m01)


}
\seealso{
\code{\link{nll_basic}}
}
