% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apa_descriptive_statistics.R
\name{apa.desc}
\alias{apa.desc}
\title{Report descriptive statistics for a set of values}
\usage{
apa.desc(
  .data,
  .dv = NULL,
  show.mean = NULL,
  show.sd = NULL,
  show.se = NULL,
  show.conf.interval = NULL,
  show.N = NULL,
  number.decimals = NULL
)
}
\arguments{
\item{.data}{A data frame or data frame extension (e.g., tibble)}

\item{.dv}{Name of the dependent variable column}

\item{show.mean}{Show mean (Bool. Default TRUE)}

\item{show.sd}{Show standard deviation (Bool. Default TRUE)}

\item{show.se}{Show standard error (Bool. Default FALSE)}

\item{show.conf.interval}{Show confidence interval (Bool. Default TRUE)}

\item{show.N}{Show number of cases (Bool. Default TRUE)}

\item{number.decimals}{Number of decimals in output}
}
\value{
R Markdown text
}
\description{
Report descriptive statistics for a set of values
}
\examples{
# 2-way ANOVA Example
if  (requireNamespace("apaTables", quietly = TRUE)){
    library(dplyr)
    goggles <- apaTables::goggles

    #Main Effect Means: Gender
    goggles \%>\% filter(gender == "Female") \%>\% apa.desc(attractiveness)
    goggles \%>\% filter(gender == "Male") \%>\% apa.desc(attractiveness)

    # Main Effect Means: Alcohol
    goggles \%>\% filter(alcohol == "None") \%>\% apa.desc(attractiveness)
    goggles \%>\% filter(alcohol == "2 Pints") \%>\% apa.desc(attractiveness)
    goggles \%>\% filter(alcohol == "4 Pints") \%>\% apa.desc(attractiveness)

    # Single Cell Mean
    goggles \%>\% filter(alcohol == "4 Pints", gender == "Female") \%>\%
                apa.desc(attractiveness)
}
}
