% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apa_correlation.R
\name{apa.r.compare.across.samples}
\alias{apa.r.compare.across.samples}
\title{Report difference between correlations in markdown APA style from different samples}
\usage{
apa.r.compare.across.samples(
  formula,
  data1,
  data2,
  alternative = "two.sided",
  show.conf.interval = NULL,
  show.N = NULL,
  show.p = NULL,
  show.statistic = NULL
)
}
\arguments{
\item{formula}{Formula for comparing correlations}

\item{data1}{Project data frame 1 name}

\item{data2}{Project data frame 2 name}

\item{alternative}{Alternative hypothesis to pass to alternative argument of cocor.indep.groups. Default is "two.sided"}

\item{show.conf.interval}{Show confidence interval or not (TRUE/FALSE). Default behavior is TRUE.}

\item{show.N}{Show sample size or not (TRUE/FALSE). Default behavior is TRUE.}

\item{show.p}{Show p-value or not (TRUE/FALSE). Default behavior is TRUE.}

\item{show.statistic}{Show test statistic or not (TRUE/FALSE). Default behavior is TRUE.}
}
\value{
R Markdown text
}
\description{
Report difference between correlations in markdown APA style from different samples
}
\examples{

# Test difference between r(rating, learning) from dataset: attitude
# and r(weight, height) from dataset: women

apa.r.compare.across.samples(formula = ~ rating + learning | height + weight,
                             data1 = attitude,
                             data2 = women)
}
