% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apa.R
\name{apa}
\alias{apa}
\title{APA Formatting for RMarkdown Reports}
\usage{
apa(x, effect = NULL, format = "rmarkdown", print = FALSE, ...)
}
\arguments{
\item{x}{An \R object. Must be a call to one of \code{afex::aov_4},
\code{afex::aov_car}, \code{afex::aov_ez}, \code{chisq.test},
\code{cor.test}, \code{ez::ezANOVA} or \code{t_test}.}

\item{effect}{(only applicable if \code{x} is an ANOVA) Character string
indicating the name of the effect to display. If is \code{NULL}, all
effects are reported (default).}

\item{format}{Character string specifying the output format. One of
\code{"text"}, \code{"markdown"}, \code{"rmarkdown"}, \code{html},
\code{"latex"} or \code{"docx"}.}

\item{print}{Logical indicating whether to return the result as an \R object
(\code{FALSE}) or print using \code{cat} (\code{TRUE}).}

\item{...}{Further arguments passed to other methods}
}
\description{
A wrapper around the \code{*_apa} functions, providing a convenient way to
use the formatters in inline code in RMarkdown documents.
}
\seealso{
\link{anova_apa}, \link{chisq_apa},
  \link{cor_apa}, \link{t_apa}
}
