% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apex-utils.R
\name{ax_forecast_data_points}
\alias{ax_forecast_data_points}
\title{Forecast data points}
\usage{
ax_forecast_data_points(
  ax,
  count = NULL,
  fillOpacity = NULL,
  strokeWidth = NULL,
  dashArray = NULL,
  ...
)
}
\arguments{
\item{ax}{An \code{\link[=apexchart]{apexchart()}} \code{htmlwidget} object.}

\item{count}{Number of ending data-points you want to indicate as a forecast or prediction values.
The ending line/bar will result into a dashed border with a distinct look to differentiate from the rest of the data-points.}

\item{fillOpacity}{Opacity of the fill attribute.}

\item{strokeWidth}{Sets the width of the points.}

\item{dashArray}{Creates dashes in borders of svg path. Higher number creates more space between dashes in the border.}

\item{...}{Additional arguments (not used).}
}
\value{
An \code{\link[=apexchart]{apexchart()}} \code{htmlwidget} object.
}
\description{
Forecast data points
}
\examples{
# add 5 predictions to data then plot it
data.frame(
  time = seq_len(53),
  lh = c(
    as.vector(lh),
    as.vector(predict(arima(lh, order = c(1,0,1)), 5)$pred)
  )
) \%>\% 
  apex(aes(time, lh), type = "line") \%>\% 
  ax_xaxis(type = "numeric") \%>\% 
  ax_forecast_data_points(count = 5)
}
