% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apex-options.R
\name{bar_opts}
\alias{bar_opts}
\title{Bar options}
\usage{
bar_opts(
  horizontal = NULL,
  endingShape = NULL,
  columnWidth = NULL,
  barHeight = NULL,
  distributed = NULL,
  colors = NULL,
  dataLabels = NULL,
  ...
)
}
\arguments{
\item{horizontal}{Logical. This option will turn a column chart into a horizontal bar chart.}

\item{endingShape}{Available Options: \code{"flat"} or \code{"rounded"}.}

\item{columnWidth}{In column charts, columnWidth is the percentage of the available width in the grid-rect.}

\item{barHeight}{In horizontal bar charts, barHeight is the percentage of the available height in the grid-rect.}

\item{distributed}{Logical. Turn this option to make the bars discrete. Each value indicates one bar per series.}

\item{colors}{A list of parameters.}

\item{dataLabels}{List with fields \code{position} (available options: \code{"top"}, \code{"center"} or \code{"bottom"})}

\item{...}{Additional parameters.}
}
\value{
A \code{list} of options that can be used in \code{\link[=ax_plotOptions]{ax_plotOptions()}}.
}
\description{
Use these options in \code{\link[=ax_plotOptions]{ax_plotOptions()}}.
}
\note{
See \url{https://apexcharts.com/docs/options/plotoptions/bar/}.
}
\examples{

data("mpg", package = "ggplot2")

apex(mpg, aes(manufacturer)) \%>\% 
  ax_plotOptions(
    bar = bar_opts(
      endingShape = "rounded",
      columnWidth = 100,
      distributed = TRUE
    )
  )
  
}
