% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isolation-fit.R
\name{apd_isolation}
\alias{apd_isolation}
\alias{apd_isolation.default}
\alias{apd_isolation.data.frame}
\alias{apd_isolation.matrix}
\alias{apd_isolation.formula}
\alias{apd_isolation.recipe}
\title{Fit an isolation forest to estimate an applicability domain.}
\usage{
apd_isolation(x, ...)

\method{apd_isolation}{default}(x, ...)

\method{apd_isolation}{data.frame}(x, ...)

\method{apd_isolation}{matrix}(x, ...)

\method{apd_isolation}{formula}(formula, data, ...)

\method{apd_isolation}{recipe}(x, data, ...)
}
\arguments{
\item{x}{Depending on the context:
\itemize{
\item A \strong{data frame} of predictors.
\item A \strong{matrix} of predictors (see the \code{categ_cols} argument of
\code{\link[isotree:isolation.forest]{isotree::isolation.forest()}}).
\item A \strong{recipe} specifying a set of preprocessing steps
created from \code{\link[recipes:recipe]{recipes::recipe()}}.
}}

\item{...}{Options to pass to \code{\link[isotree:isolation.forest]{isotree::isolation.forest()}}. Options should
not include \code{data}.}

\item{formula}{A formula specifying the predictor terms on the right-hand
side. No outcome should be specified.}

\item{data}{When a \strong{recipe} or \strong{formula} is used, \code{data} is specified as:
\itemize{
\item A \strong{data frame} containing the predictors.
}}
}
\value{
A \code{apd_isolation} object.
}
\description{
\code{apd_isolation()} fits an isolation forest model.
}
\details{
In an isolation forest, splits are designed to isolate individual data points.
The tree construction process takes random split locations on randomly
selected predictors. As splits are made in the tree, the algorithm tracks
when data points are isolated as more splits are made. The first points that
are isolated are thought to be outliers or anomalous. From these results, an
anomaly score can be constructed.

This function creates an isolation forest on the training set and measures
the reference distribution of the scores when re-predicting the training set.
When scoring new data, the raw anomaly score is produced along with the
sample's corresponding percentile of the reference distribution.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
if (rlang::is_installed(c("isotree", "modeldata"))) {
  library(dplyr)

  data(cells, package = "modeldata")

  cells_tr <- cells \%>\% filter(case == "Train") \%>\% select(-case, -class)
  cells_te <- cells \%>\% filter(case != "Train") \%>\% select(-case, -class)

  if_mod <- apd_isolation(cells_tr, ntrees = 10, nthreads = 1)
  if_mod
}
\dontshow{\}) # examplesIf}
}
\references{
Liu, Fei Tony, Kai Ming Ting, and Zhi-Hua Zhou. "Isolation forest."
2008 \emph{Eighth IEEE International Conference on Data Mining. IEEE}, 2008.
Liu, Fei Tony, Kai Ming Ting, and Zhi-Hua Zhou. "Isolation-based anomaly
detection." \emph{ACM Transactions on Knowledge Discovery from Data (TKDD)} 6.1
(2012): 3.
}
