% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apsimx_soil_profile.R
\name{available_water_content}
\alias{available_water_content}
\title{Calculate available water content}
\usage{
available_water_content(
  x,
  depth,
  area = c("m", "m2", "ha"),
  method = c("linear", "constant"),
  weights,
  ...
)
}
\arguments{
\item{x}{object of class \sQuote{soil_profile}}

\item{depth}{soil depth (in meters). If missing then the whole soil profile is used.}

\item{area}{either \sQuote{m} meter, \sQuote{m2} meter squared or \sQuote{ha}.}

\item{method}{interpolation method. Either \sQuote{linear} or \sQuote{constant}.}

\item{weights}{optional weights}

\item{...}{additional arguments passed to internal functions (none used at the moment).}
}
\value{
returns a value with attribute \sQuote{units} and \sQuote{depth}
}
\description{
Calculation of available water content based on an object of class \sQuote{soil_profile}
}
\details{
Function to calculate available water content. The output units depend on the choice of area.
If \sQuote{m} is used, then the output units will be \sQuote{mm}. If the \sQuote{area} is \sQuote{m2},
then the output units will be in \sQuote{m3}. If the \sQuote{area} is \sQuote{ha}, then the output units will be \sQuote{kg/ha}.
}
\examples{
\dontrun{
sp <- apsimx_soil_profile()
available_water_content(sp)
}
}
