% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edit_apsim_xml.R
\name{edit_apsim_xml}
\alias{edit_apsim_xml}
\title{Edit an APSIM (Classic) Simulation auxiliary xml file}
\usage{
edit_apsim_xml(
  file,
  src.dir = ".",
  wrt.dir = NULL,
  parm.path = NULL,
  value = NULL,
  overwrite = FALSE,
  edit.tag = "-edited",
  verbose = TRUE
)
}
\arguments{
\item{file}{file ending in .xml to be edited}

\item{src.dir}{directory containing the .xml file to be edited; defaults to the current working directory}

\item{wrt.dir}{should be used if the destination directory is different from the src.dir}

\item{parm.path}{parameter path to be edited (see example)}

\item{value}{new values for the parameter to be edited}

\item{overwrite}{logical; if \code{TRUE} the old file is overwritten, a new file is written otherwise}

\item{edit.tag}{if the file is edited a different tag from the default \sQuote{-edited} can be used.}

\item{verbose}{whether to print information about successful edit}
}
\value{
(when verbose=TRUE) complete file path to edited .xml file is returned as a character string.
As a side effect this function creates a new XML file.
}
\description{
This function allows editing of an APSIM (Classic) simulation xml file.
}
\details{
The variables specified by \code{parm} within the .apsim file specified by \code{file} 
in the source directory \code{src.dir} are edited. The old values are replaced with \code{value}, which
is a list that has the same number of elements as the length of the vector \code{parm}.  The current
.xml file will be overwritten if \code{overwrite} is set to \code{TRUE}; otherwise the file
\sQuote{file} \emph{-edited.xml} will be created.  If (verbose = TRUE) then the name
 of the written file is returned. The function is similar to the edit_sim_file functin in the \sQuote{apsimr}
 package, but with the difference that here the xml2 package is used instead.
}
\note{
This function cannot check whether replacement is of the correct length. Also, there is
an inspect equivalent. It is more flexible than \sQuote{edit_apsim} and (perhaps) similar to 
\sQuote{apsimr::edit_sim_file}.
}
\examples{
\donttest{
## This example changes the RUE values

extd.dir <- system.file("extdata", package = "apsimx")

values <- paste(rep(1.7, 12), collapse = " ")

## Writing to a temp directory, but replace as needed
tmp.dir <- tempdir()

edit_apsim_xml("Maize75.xml", 
               src.dir = extd.dir,
               wrt.dir = tmp.dir,
               parm.path = ".//Model/rue",
               value = values)
}
}
