% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_slga_soil_profile.R
\name{get_slga_soil}
\alias{get_slga_soil}
\title{Retrieve soil profile data from SLGA (Soils for Australia)}
\usage{
get_slga_soil(lonlat)
}
\arguments{
\item{lonlat}{Longitude and latitude vector (e.g. c(151.8306, -27.4969))}
}
\value{
a data.frame with elements: depth (midpoint in cm), depths (as character in cm), thickness (cm), clay, sand, silt, wv1500, wv0033, bdod, nitrogen, phh2o, cec, soc
}
\description{
This function gets a soil profile for the Australia extent
}
\details{
The data comes from https://esoil.io/TERNLandscapes/Public/Pages/SLGA/index.html
}
\examples{
\dontrun{
## retrieve data from longitude and latitude 151.8305805675806 and -27.496873026858598
## Note: This can take a couple of minutes
slga.soil <- get_slga_soil(lonlat = c(151.8306, -27.4969)) 

}
}
\author{
Chloe (Yunru Lai) and Fernando E. Miguez
}
