% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/texture.R
\name{lookup_taxpartsize}
\alias{lookup_taxpartsize}
\title{Ranking Systems for USDA Taxonomic Particle-Size and Substitute Classes of Mineral Soils}
\usage{
lookup_taxpartsize()
}
\value{
A data.frame with a rank column, taxonomic family particle size class, and a flag for contrasting.
}
\description{
Generate a lookup table of USDA Particle-Size and Substitute Classes  names, ranked according to approximate particle size
}
\examples{

# class codes
lu <- lookup_taxpartsize()

idx <- lu$contrasting == FALSE

lu$taxpartsize[idx]

lu$rank[as.integer(lu$taxpartsize)[idx]]

}
\references{
\href{https://nrcspad.sc.egov.usda.gov/DistributionCenter/product.aspx?ProductID=991}{Field Book for Describing and Sampling Soils, version 3.0}
}
\seealso{
\code{\link[=hz_to_taxpartsize]{hz_to_taxpartsize()}}, \code{\link[=texture_to_taxpartsize]{texture_to_taxpartsize()}}, \code{\link[=SoilTextureLevels]{SoilTextureLevels()}}
}
\author{
Stephen Roecker
}
