% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addArchivistHooks.R
\name{addHooksToPrint}
\alias{addHooksToPrint}
\title{Add \pkg{archivist} Hooks to \pkg{rmarkdown} Reports}
\usage{
addHooksToPrint(
  class = "ggplot",
  repoDir = aoptions("repoDir"),
  repo = aoptions("repo"),
  user = aoptions("user"),
  branch = "master",
  subdir = aoptions("subdir"),
  format = "markdown"
)
}
\arguments{
\item{class}{A character with a name of class (one or more) that should be archived.}

\item{repoDir}{A character containing a name of a Local Repository.}

\item{repo}{A character with a name of a Remote repository on which the Repository is archived.
If \code{repo = NULL} then hooks will be added to files in local directories.}

\item{user}{A character with a name of a Remote-repository user on whose account the \code{repo} is created.}

\item{branch}{A character with a name of Remote-repository's branch on which the Repository is archived. 
Default \code{branch} is \code{master}.}

\item{subdir}{A character with a name of a sub directory on a Remote repository 
on which the Repository is stored. If the Repository is stored in main folder on a Remote repository, this should be set 
to \code{subdir = "/"} as default.}

\item{format}{A character denoting \code{format} as in \link{alink}.}
}
\description{
\code{addHooksToPrint} adds an overloaded version of the print function for objects of selected class. 
The overloaded function will add all objects of selected class to the \link{Repository} and then will add hooks (to the Remote or Local Repository) 
to the HTML report (generated in \pkg{rmarkdown}) for these objects (\code{artifacts} - \link{archivistPackage}).
The great example can be seen in this blogpost.
}
\note{
One can specify \code{userTags} as in \link{saveToLocalRepo} for artifacts by adding \code{"tags"} attribute.
See note section about that in \link{saveToLocalRepo}.
}
\section{Contact}{

 
Bug reports and feature requests can be sent to 
\href{https://github.com/pbiecek/archivist/issues}{https://github.com/pbiecek/archivist/issues}
}

\examples{

\dontrun{
# only in Rmd report, links to github repository
addHooksToPrint(class="ggplot", repoDir = "arepo",
repo="graphGallery", user="pbiecek")
# only in Rmd report, links to local files
addHooksToPrint(class="ggplot", repoDir = "arepo",
repo=NULL)
}
}
\references{
Biecek P and Kosinski M (2017). "archivist: An R Package for Managing,
Recording and Restoring Data Analysis Results." _Journal of Statistical
Software_, *82*(11), pp. 1-28. doi: 10.18637/jss.v082.i11 (URL:
http://doi.org/10.18637/jss.v082.i11).
URL https://github.com/pbiecek/archivist
}
\seealso{
Other archivist: 
\code{\link{Repository}},
\code{\link{Tags}},
\code{\link{\%a\%}()},
\code{\link{addTagsRepo}()},
\code{\link{aformat}()},
\code{\link{ahistory}()},
\code{\link{alink}()},
\code{\link{aoptions}()},
\code{\link{archivistPackage}},
\code{\link{aread}()},
\code{\link{areadLocal}()},
\code{\link{asearch}()},
\code{\link{asearchLocal}()},
\code{\link{asession}()},
\code{\link{atrace}()},
\code{\link{cache}()},
\code{\link{copyLocalRepo}()},
\code{\link{createLocalRepo}()},
\code{\link{createMDGallery}()},
\code{\link{deleteLocalRepo}()},
\code{\link{getRemoteHook}()},
\code{\link{getTagsLocal}()},
\code{\link{loadFromLocalRepo}()},
\code{\link{md5hash}},
\code{\link{removeTagsRepo}()},
\code{\link{restoreLibs}()},
\code{\link{rmFromLocalRepo}()},
\code{\link{saveToLocalRepo}()},
\code{\link{searchInLocalRepo}()},
\code{\link{setLocalRepo}()},
\code{\link{shinySearchInLocalRepo}()},
\code{\link{showLocalRepo}()},
\code{\link{splitTagsLocal}()},
\code{\link{summaryLocalRepo}()},
\code{\link{zipLocalRepo}()}
}
\author{
Przemyslaw Biecek, \email{przemyslaw.biecek@gmail.com}
}
\concept{archivist}
