% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_data.R
\name{arete_data}
\alias{arete_data}
\title{Example data packaged with gecko}
\source{
This function is inspired by \code{\link[palmerpenguins:path_to_file]{palmerpanguins::path_to_file()}}
which in turn is based on \code{\link[readxl:readxl_example]{readxl::readxl_example()}}.
}
\usage{
arete_data(data = NULL)
}
\arguments{
\item{data}{character. String of one of the data names mentioned in the description, e.g.: \code{"holzapfelae"}.
If \code{NULL}, the example files will be returned.}
}
\value{
depending on \code{data} either a character (\code{"holzapfelae"}), a WebAnnoTSV object (\code{"holzapfelae-extract"}) or a list of WebAnnoTSV (\code{"annotations"}, \code{"annotations-highlights"}).
}
\description{
Load data included in the package. This includes \strong{holzapfelae}, a txt file of a paper describing Araneus holzapfelae (Dippenaar-Schoeman & Foord, 2020),
 \strong{annotations}, two files of annotated data of the same paper describing two species, Sinlathrobium assingi and Sinlathrobium chenzhilini (Chen \emph{et al.} 2024) and \strong{annotations-highlights} a version of the same two files reduced to just those sections containing annotated data.
}
\examples{
arete_data()
arete_data("holzapfelae")
}
\references{
Dippenaar-Schoeman, A. S. & Foord, S. H. (2020a). First record of the orb-web spider Araneus holzapfelae Lessert, 1936 from South Africa (Arachnida: Araneidae). Sansa News 35: 19-21.
Chen, X., Ye, J.-P. and Peng, Z. (2024) ‘Two new species and additional records of Sinlathrobium Assing (Coleoptera, Staphylinidae, Paederinae) from southern China’, ZooKeys, 1218, pp. 25–33. doi:10.3897/zookeys.1218.128973.
}
