% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shortcut_functions.R
\name{darf}
\alias{darf}
\title{Shortcut likelihood function}
\usage{
darf(x, query = NULL, ...)
}
\arguments{
\item{x}{Input data. Integer variables are recoded as ordered factors with
a warning. See Details.}

\item{query}{Data frame of samples, optionally comprising just a subset of
training features. See Details of \code{lik}. Is set to \code{x} if \code{zero}.}

\item{...}{Extra parameters to be passed to \code{adversarial_rf}, \code{forde}
and \code{lik}.}
}
\value{
A vector of likelihoods, optionally on the log scale. A dataset of
\code{n_synth} synthetic samples or of \code{nrow(x)} synthetic
samples if \code{n_synth} is undefined.
}
\description{
Calls \code{adversarial_rf}, \code{forde} and \code{lik}.
For repeated application, it is faster to save outputs of \code{adversarial_rf}
and \code{forde} and pass them via \code{...} or directly use \code{lik}.
}
\examples{
# Estimate log-likelihoods
ll <- darf(iris)

# Partial evidence query
ll <- darf(iris, query = iris[1, 1:3])

# Condition on Species = "setosa"
ll <- darf(iris, query = iris[1, 1:3], evidence = data.frame(Species = "setosa"))


}
\references{
Watson, D., Blesch, K., Kapar, J., & Wright, M. (2023). Adversarial random
forests for density estimation and generative modeling. In \emph{Proceedings
of the 26th International Conference on Artificial Intelligence and
Statistics}, pp. 5357-5375.
}
\seealso{
\code{\link{arf}}, \code{\link{adversarial_rf}}, \code{\link{forde}}, \code{\link{forge}}
}
