% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeNd.R, R/restoredim.R
\name{makeNd}
\alias{makeNd}
\alias{restoredim}
\title{Ensure/collapse an array into \code{n} dimensions and restore the old dimensions}
\usage{
makeNd(a, N)

restoredim(
  a,
  old = NULL,
  n = 1L,
  ...,
  usedim = TRUE,
  fromend = FALSE,
  drop = FALSE
)
}
\arguments{
\item{a}{an array (matrix, vector)}

\item{N}{the desired number of dimensions, 0 to remove the \code{dim} and \code{dimnames}
attributes (i.e. to create a vector).}

\item{old}{list containing a list with (possibly) elements \code{dim}, \code{dimnames}, and
\code{names}. The nth last element of this list is used.}

\item{n}{how many makeNdim steps to go back?}

\item{...}{ignored}

\item{usedim}{use only the specified dimensions}

\item{fromend}{if \code{TRUE}, numeric \code{usedim} are counted from the end, see details.}

\item{drop}{should 1d arrays drop to vectors?}
}
\value{
N-dimensional array

an array
}
\description{
\code{nameNd} ensures a given number of dimensions:
If \code{a} has less than \code{N} dimensions, new dimensions of length 1 are appended.
If \code{a} has more than \code{N} dimensions, the supernumerary dimensions are collapsed onto
the last dimension.

Attributes \code{old.dim} and \code{old.dimnames} are used by default. \code{restoredim} is the
inverse of \code{makeNd}.
}
\details{
Note that missing attributes as well as \code{old.dim = NULL} produce a (dimensionless)
vector. This is also the case if \code{a} lost the \code{old.*} attributes during 
computations like \code{as.numeric}, \code{c}, etc..

\code{fromend} together with numeric \code{usedim} specifies dimensions counting from the
end. E.g. \code{fromend = TRUE} and \code{usedim = 1 : 3} for an array to be restored to 10d
means restoring dimensions 8 : 10. \code{fromend = TRUE} and \code{usedim = -(1 : 3)} restores
dimensions 1 to 7.
}
\examples{
v <- arrayhelpers:::v
v
makeNd (v, 1)
dim (makeNd (v, 1))
dim (makeNd (v, 3))

m <- arrayhelpers:::m
m
makeNd (m, 1)
dim (makeNd (m, 1))
makeNd (m, 0) 
dim (makeNd (m, 0))
makeNd (m, 3)

a <- arrayhelpers:::a
a
dim (makeNd (a, 1))
dim (makeNd (a, 0))
makeNd (a,  2)          
makeNd (a, -2)
makeNd (a, -4)
makeNd (a, 3);


a <- array (1 : 24, 4 : 3)
a
restoredim (makeNd (a, 0))

x <- makeNd (a, 0)
attr (x, "old")

}
\author{
Claudia Beleites

Claudia Beleites
}
