% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{opt}
\alias{opt}
\title{Specify an option in long or short form}
\usage{
opt(label, description, arg = FALSE, default = NA_character_)
}
\arguments{
\item{label}{A short-form (single character) and/or long-form label for the
option, specified comma-separated in a single string. At most one of each
form must be given. Leading hyphens are optional.}

\item{description}{A textual description of the option, for use in the usage
summary.}

\item{arg}{The name of the option's argument, if it takes one. Otherwise
\code{FALSE}, indicating no argument.}

\item{default}{A default value for the argument, if one is accepted. This
does not have to be a string, and arguments will be coerced to match the
mode of the default when parsed. If the option takes no argument the
default value will be \code{FALSE}.}
}
\value{
A data frame giving details of the option. This will not usually be
used directly, but passed to \code{\link[=arrg]{arrg()}}.
}
\description{
This function specifies an option that is accepted by an argument parser.
The results of one or more calls to this function are typically passed to
\code{\link[=arrg]{arrg()}}.
}
\examples{
  # A simple flag-style option with no argument
  opt("h,help", "Display this usage information and exit")
  
  # An option that takes an integer argument called "count"
  opt("n,times", "Run this many times", arg="count", default=1L)

}
\seealso{
\code{\link[=arrg]{arrg()}}
}
\author{
Jon Clayden
}
