% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset-format.R
\name{CsvFileFormat}
\alias{CsvFileFormat}
\title{CSV dataset file format}
\value{
A \code{CsvFileFormat} object
}
\description{
A \code{CSVFileFormat} is a \link{FileFormat} subclass which holds information about how to
read and parse the files included in a CSV \code{Dataset}.
}
\section{Factory}{

\code{CSVFileFormat$create()} can take options in the form of lists passed through as \code{parse_options},
\code{read_options}, or \code{convert_options} parameters.  Alternatively, readr-style options can be passed
through individually.  While it is possible to pass in \code{CSVReadOptions}, \code{CSVConvertOptions}, and \code{CSVParseOptions}
objects, this is not recommended as options set in these objects are not validated for compatibility.
}

\examples{
\dontshow{if (arrow_with_dataset()) withAutoprint(\{ # examplesIf}
# Set up directory for examples
tf <- tempfile()
dir.create(tf)
on.exit(unlink(tf))
df <- data.frame(x = c("1", "2", "NULL"))
write.table(df, file.path(tf, "file1.txt"), sep = ",", row.names = FALSE)

# Create CsvFileFormat object with Arrow-style null_values option
format <- CsvFileFormat$create(convert_options = list(null_values = c("", "NA", "NULL")))
open_dataset(tf, format = format)

# Use readr-style options
format <- CsvFileFormat$create(na = c("", "NA", "NULL"))
open_dataset(tf, format = format)
\dontshow{\}) # examplesIf}
}
\seealso{
\link{FileFormat}
}
