/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.StringTokenizer;

public class AprioriTFPclass
extends PartialSupportTree {
    protected int kValue = 5;
    protected final int MAX_SIZE_OF_ANTECEDENT = 6;
    protected short[][] testDataArray = null;
    protected short[][][] tenthDataSets = new short[10][][];
    protected boolean ruleListAttNumOutputFlag = false;
    protected boolean ruleListSchemaOutputFlag = false;
    protected int numRowsInInputSet;
    protected int numRowsInTestSet;
    protected int numColsInTestSet;
    protected int numRowsInTrainingSet;
    protected double accuracy;
    protected int numCRs;
    protected double aucValue;
    protected JTextArea textArea = null;
    protected double averageAccuracy;
    protected double averageAUCvalue;
    protected double sdAccuracy;
    protected double averageNumFreqSets;
    protected double averageNumUpdates;
    protected double averageNumCRs;

    public AprioriTFPclass(String[] stringArray) {
        super(stringArray);
        TtreeNode.setNumberOfNodesFieldToZero();
    }

    public AprioriTFPclass(AssocRuleMining assocRuleMining) {
        super(assocRuleMining);
        this.numClasses = assocRuleMining.numClasses;
        TtreeNode.setNumberOfNodesFieldToZero();
    }

    public AprioriTFPclass() {
        TtreeNode.setNumberOfNodesFieldToZero();
    }

    @Override
    protected void idArgument(String string) {
        if (string.length() < 3) {
            JOptionPane.showMessageDialog(null, "Command line argument '" + string + "' too short.", "COMMAND LINE INPUT ERROR", 0);
            this.errorFlag = false;
        } else if (string.charAt(0) == '-') {
            char c = string.charAt(1);
            string = string.substring(2, string.length());
            switch (c) {
                case 'C': {
                    this.confidence = Double.parseDouble(string);
                    break;
                }
                case 'F': {
                    this.fileName = string;
                    break;
                }
                case 'N': {
                    this.numClasses = Integer.parseInt(string);
                    break;
                }
                case 'O': {
                    this.outputFileName = string;
                    this.setOutputRuleSetToFileFlag(true);
                    break;
                }
                case 'S': {
                    this.support = Double.parseDouble(string);
                    break;
                }
                case 'T': {
                    this.testSetFileName = string;
                    break;
                }
                default: {
                    JOptionPane.showMessageDialog(null, "Unrecognise command line argument: '" + c + string + "'.", "COMMAND LINE INPUT ERROR", 0);
                    this.errorFlag = false;
                    break;
                }
            }
        } else {
            JOptionPane.showMessageDialog(null, "All command line arguments must commence with a '-' character ('" + string + "').", "COMMAND LINE INPUT ERROR", 0);
            this.errorFlag = false;
        }
    }

    @Override
    protected void CheckInputArguments() {
        this.checkSupportAndConfidence();
        this.checkFileName();
        this.checkNumClasses();
        if (this.errorFlag) {
            this.outputSettings();
        } else {
            this.outputMenu();
        }
    }

    private void checkNumClasses() {
        if (this.numClasses == 0) {
            JOptionPane.showMessageDialog(null, "Must specify number of classes (-N)", "COMMAND LINE INPUT ERROR", 0);
            this.errorFlag = false;
        }
        if (this.numClasses < 0) {
            JOptionPane.showMessageDialog(null, "Number of classes must be a positive integer", "COMMAND LINE INPUT ERROR", 0);
            this.errorFlag = false;
        }
    }

    public void inputTestDataSet() {
        this.readTestFile();
        if (this.inputFormatOkFlag) {
            if (this.checkTestSetOrdering()) {
                this.countNumColsInTestSet();
                String string = "Num. records in testset = " + this.numRowsInTestSet + "\nNum. columns in testset = " + this.numColsInTestSet + "\n";
                System.out.print(string);
                if (this.numColsInTestSet != this.numCols) {
                    JOptionPane.showMessageDialog(null, "Number of columns in test set is not the\nsame as number of columns in training set\n", "FILE INPUT ERROR", 0);
                    System.exit(1);
                }
            } else {
                JOptionPane.showMessageDialog(null, "Unable to read file " + this.fileName + "\n", "FILE INPUT ERROR", 0);
                this.closeFile();
                System.exit(1);
            }
        }
        this.numRowsInTrainingSet = this.numRows;
    }

    private void readTestFile() {
        try {
            this.inputFormatOkFlag = true;
            this.numRowsInTestSet = this.getNumberOfLines(this.testSetFileName);
            if (this.inputFormatOkFlag) {
                this.testDataArray = new short[this.numRowsInTestSet][];
                System.out.println("Reading test set input file: " + this.testSetFileName);
                this.readTestDataSet();
            } else {
                JOptionPane.showMessageDialog(null, "Unable to read file: " + this.testSetFileName + "\n", "FILE INPUT ERROR", 0);
            }
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "Unable to read file", "FILE INPUT ERROR", 0);
            this.closeFile();
            System.exit(1);
        }
    }

    public void readTestDataSet() throws IOException {
        int n = 0;
        this.openFileName(this.testSetFileName);
        String string = this.fileInput.readLine();
        while (string != null && this.processTestSetLine(string, n)) {
            ++n;
            string = this.fileInput.readLine();
        }
        this.closeFile();
    }

    private boolean processTestSetLine(String string, int n) {
        if (string == null) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n2 = stringTokenizer.countTokens();
        if (n2 == 0) {
            return false;
        }
        short[] sArray = this.binConversion(stringTokenizer, n2);
        int n3 = sArray.length;
        this.testDataArray[n] = new short[n3];
        for (int i = 0; i < n3; ++i) {
            this.testDataArray[n][i] = sArray[i];
        }
        return true;
    }

    protected boolean checkTestSetOrdering() {
        boolean bl = true;
        for (int i = 0; i < this.testDataArray.length; ++i) {
            if (this.checkLineOrdering(i + 1, this.testDataArray[i])) continue;
            bl = false;
        }
        return bl;
    }

    private void countNumColsInTestSet() {
        int n = 0;
        for (int i = 0; i < this.testDataArray.length; ++i) {
            int n2 = this.testDataArray[i].length - 1;
            if (this.testDataArray[i][n2] <= n) continue;
            n = this.testDataArray[i][n2];
        }
        this.numColsInTestSet = n;
    }

    public void recastTestData() {
        for (int i = 0; i < this.testDataArray.length; ++i) {
            short[] sArray = new short[this.testDataArray[i].length];
            for (int j = 0; j < this.testDataArray[i].length; ++j) {
                short s = this.testDataArray[i][j];
                sArray[j] = (short)this.conversionArray[s][0];
            }
            this.sortItemSet(sArray);
            this.testDataArray[i] = sArray;
        }
    }

    @Override
    public void idInputDataOrdering() {
        int[][] nArray = this.countSingles();
        this.orderFirstNofCountArray(nArray, this.numCols - this.numClasses);
        this.defConvertArrays(nArray, this.numCols - this.numClasses);
        this.isOrderedFlag = true;
    }

    public void pruneUnsupportedAtts() {
        for (int i = 0; i < this.dataArray.length; ++i) {
            if (this.dataArray[i] == null) continue;
            short[] sArray = null;
            int n = this.dataArray[i].length - 1;
            for (int j = 0; j < n; ++j) {
                short s = this.dataArray[i][j];
                if (!((double)this.conversionArray[s][1] >= this.minSupport)) continue;
                sArray = this.reallocInsert(sArray, (short)this.conversionArray[s][0]);
            }
            sArray = this.reallocInsert(sArray, this.dataArray[i][n]);
            this.dataArray[i] = sArray;
        }
        this.numOneItemSets = this.getNumSupOneItemSets();
        this.recastClassifiers();
    }

    private void recastClassifiers() {
        int n;
        int n2;
        short s = (short)(this.numCols - this.numOneItemSets);
        for (n2 = 0; n2 < this.dataArray.length; ++n2) {
            int n3 = this.dataArray[n2].length - 1;
            this.dataArray[n2][n3] = (short)(this.dataArray[n2][n3] - s);
        }
        n2 = this.numOneItemSets - this.numClasses + 1;
        short s2 = (short)(this.numCols - this.numClasses + 1);
        for (n = 0; n < this.numClasses; ++n) {
            this.reconversionArray[n2 + n] = s2;
            s2 = (short)(s2 + 1);
        }
        for (n = n2 + this.numClasses; n < this.reconversionArray.length; ++n) {
            this.reconversionArray[n] = 0;
        }
    }

    @Override
    protected int getNumSupOneItemSets() {
        int n = 0;
        int n2 = this.conversionArray.length - this.numClasses;
        for (int i = 1; i < n2; ++i) {
            if (!((double)this.conversionArray[i][1] >= this.minSupport)) continue;
            ++n;
        }
        return n + this.numClasses;
    }

    public void createTrainingAndTestDataSets() {
        int n;
        this.numRowsInTestSet = (int)((double)this.numRows * 50.0 / 100.0);
        this.numRows = this.numRowsInTrainingSet = this.numRows - this.numRowsInTestSet;
        short[][] sArrayArray = new short[this.numRowsInTrainingSet][];
        for (n = 0; n < this.numRowsInTrainingSet; ++n) {
            sArrayArray[n] = this.dataArray[n];
        }
        this.testDataArray = new short[this.numRowsInTestSet][];
        int n2 = 0;
        while (n < this.dataArray.length) {
            this.testDataArray[n2] = this.dataArray[n];
            ++n;
            ++n2;
        }
        this.dataArray = sArrayArray;
    }

    public void createTrainingAndTestDataSets(int n) {
        int n2;
        int n3;
        this.numRowsInTestSet = this.tenthDataSets[n].length;
        this.testDataArray = this.tenthDataSets[n];
        this.numRows = this.numRowsInTrainingSet = this.numRowsInInputSet - this.numRowsInTestSet;
        short[][] sArrayArray = new short[this.numRows][];
        int n4 = 0;
        for (n3 = 0; n3 < n; ++n3) {
            n2 = 0;
            while (n2 < this.tenthDataSets[n3].length) {
                sArrayArray[n4] = this.tenthDataSets[n3][n2];
                ++n2;
                ++n4;
            }
        }
        for (n3 = n + 1; n3 < this.tenthDataSets.length; ++n3) {
            n2 = 0;
            while (n2 < this.tenthDataSets[n3].length) {
                sArrayArray[n4] = this.tenthDataSets[n3][n2];
                ++n2;
                ++n4;
            }
        }
        this.dataArray = sArrayArray;
    }

    public void createTenthsDataSets() {
        if (this.numRows < 10) {
            JOptionPane.showMessageDialog(null, "Only " + this.numRows + ", therefore cannot create tenths data sets!", "TCV ERROR", 0);
            System.exit(1);
        }
        int n = this.numRows / 10;
        int n2 = this.numRows - n * 10;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            this.tenthDataSets[n3] = new short[n + 1][];
            ++n4;
            ++n3;
        }
        while (n3 < this.tenthDataSets.length) {
            this.tenthDataSets[n3] = new short[n][];
            ++n3;
        }
        n4 = 0;
        for (n3 = 0; n3 < this.tenthDataSets.length; ++n3) {
            int n5 = 0;
            while (n5 < this.tenthDataSets[n3].length) {
                this.tenthDataSets[n3][n5] = this.dataArray[n4];
                ++n5;
                ++n4;
            }
        }
    }

    public void startClassification() {
    }

    public void startClassification(JTextArea jTextArea) {
    }

    public void commenceTCVwithOutput() {
    }

    public void commenceTCVwithOutput(JTextArea jTextArea) {
        this.textArea = jTextArea;
    }

    public void startHillClimbing(double d, double d2, double d3, double d4) {
    }

    public void startHillClimbing(JTextArea jTextArea, double d, double d2, double d3, double d4) {
    }

    protected void findDefaultRule() {
        Object object;
        int n;
        block2: {
            if (this.numRules == 0) {
                return;
            }
            n = this.numRules;
            short[] sArray = this.getConsequentOfRuleN(n);
            do {
                if (--n != 0) continue;
                ++n;
                break block2;
            } while (sArray[0] == (object = this.getConsequentOfRuleN(n))[0]);
            ++n;
        }
        object = this.startRulelist;
        this.startRulelist = null;
        this.numRules = n;
        this.copyFirstNrules(this.numRules, (RuleNode)object);
    }

    protected short classifyRecordDefault(short[] sArray) {
        return this.classifyRecordDefault(sArray, this.startRulelist);
    }

    protected short classifyRecordDefault(short[] sArray, RuleNode ruleNode) {
        if (ruleNode != null) {
            short s = this.classifyRecordDefault(sArray, ruleNode.leftBranch);
            if (s != 0) {
                return s;
            }
            if (ruleNode.ruleNumber == this.numRules || this.isSubset(ruleNode.antecedent, sArray)) {
                return ruleNode.consequent[0];
            }
            return this.classifyRecordDefault(sArray, ruleNode.rightBranch);
        }
        return 0;
    }

    protected void testClassification() {
        int n;
        int n2;
        int n3;
        int n4;
        if (!this.canTestingBeUndertaken()) {
            this.accuracy = 0.0;
            this.aucValue = 0.0;
            return;
        }
        int[][] nArray = new int[this.testDataArray.length][this.numClasses];
        int[][] nArray2 = new int[this.testDataArray.length][this.numClasses];
        for (n4 = 0; n4 < nArray.length; ++n4) {
            for (n3 = 0; n3 < nArray[n4].length; ++n3) {
                nArray[n4][n3] = 0;
            }
        }
        for (n4 = 0; n4 < nArray2.length; ++n4) {
            for (n3 = 0; n3 < nArray2[n4].length; ++n3) {
                nArray2[n4][n3] = 0;
            }
        }
        n4 = 0;
        n3 = 0;
        int n5 = 0;
        int n6 = this.numOneItemSets - this.numClasses + 1;
        for (n2 = 0; n2 < this.testDataArray.length; ++n2) {
            short s = this.classifyRecordDefault(this.testDataArray[n2]);
            if (s == 0) {
                ++n5;
                continue;
            }
            short s2 = this.getLastElement(this.testDataArray[n2]);
            n = s2 - n6;
            nArray[n2][n] = 1;
            n = s - n6;
            nArray2[n2][n] = 1;
            if (s == s2) {
                ++n4;
                continue;
            }
            ++n3;
        }
        this.accuracy = (double)n4 * 100.0 / (double)n2;
        double d = 0.0;
        for (n = 0; n < this.numClasses - 1; ++n) {
            for (int i = n + 1; i < this.numClasses; ++i) {
                double d2 = this.calcMWWstatValue(n, i, nArray2, nArray);
                double d3 = this.calcMWWstatValue(i, n, nArray2, nArray);
                double d4 = (d2 + d3) / 2.0;
                d += d4;
            }
        }
        this.aucValue = 2.0 / ((double)this.numClasses * ((double)this.numClasses - 1.0)) * d;
    }

    protected double calcMWWstatValue(int n, int n2, int[][] nArray, int[][] nArray2) {
        int n3;
        int n4 = 0;
        for (int i = 0; i < nArray2.length; ++i) {
            if (nArray2[i][n] != 1 && nArray2[i][n2] != 1) continue;
            ++n4;
        }
        int[][] nArray3 = new int[n4][2];
        int n5 = 0;
        for (n3 = 0; n3 < nArray2.length; ++n3) {
            if (nArray2[n3][n] != 1 && nArray2[n3][n2] != 1) continue;
            nArray3[n5][0] = nArray[n3][n];
            nArray3[n5][1] = nArray2[n3][n];
            ++n5;
        }
        this.rankMWWtable(nArray3);
        n3 = 0;
        int n6 = 0;
        int n7 = 0;
        for (int i = 0; i < nArray3.length; ++i) {
            if (nArray3[i][1] == 1) {
                ++n3;
                n7 = n7 + i + 1;
                continue;
            }
            ++n6;
        }
        double d = n3 == 0 || n6 == 0 ? 0.0 : ((double)n7 - (double)n3 * (double)(n3 + 1) / 2.0) / (double)(n3 * n6);
        return d;
    }

    private void rankMWWtable(int[][] nArray) {
        boolean bl;
        do {
            bl = true;
            int n = 0;
            while (n < nArray.length - 1) {
                if (this.isBeforeInMWWtable(nArray[n][0], nArray[n][1], nArray[n + 1][0], nArray[n + 1][1])) {
                    ++n;
                    continue;
                }
                bl = false;
                int n2 = nArray[n][0];
                int n3 = nArray[n][1];
                nArray[n][0] = nArray[n + 1][0];
                nArray[n][1] = nArray[n + 1][1];
                nArray[n + 1][0] = n2;
                nArray[n + 1][1] = n3;
                ++n;
            }
        } while (!bl);
    }

    private boolean isBeforeInMWWtable(int n, int n2, int n3, int n4) {
        boolean bl = false;
        bl = n == 0 ? (n2 == 1 ? true : (n3 == 0 ? n4 != 1 : true)) : (n2 == 0 ? n3 != 0 : (n3 == 0 ? false : n4 != 0));
        return bl;
    }

    private boolean canTestingBeUndertaken() {
        if (this.testDataArray == null) {
            String string = "WARNING: No test data\n";
            if (this.textArea == null) {
                System.out.print(string);
            } else {
                this.textArea.append(string);
            }
            return false;
        }
        if (this.startRulelist == null) {
            String string = "No classification rules generated!\n";
            if (this.textArea == null) {
                System.out.print(string);
            } else {
                this.textArea.append(string);
            }
            return false;
        }
        return true;
    }

    protected double testClassificationBestK() {
        int n;
        int n2 = 0;
        if (this.testDataArray == null) {
            if (this.textArea == null) {
                System.out.println("WARNING: No test data");
            }
            this.textArea.append("WARNING: No test data\n");
            return 0.0;
        }
        if (this.startRulelist == null) {
            String string = "No classification rules generated!\n";
            if (this.textArea == null) {
                System.out.print(string);
            } else {
                this.textArea.append(string);
            }
            return 0.0;
        }
        short[] sArray = this.createClassifiersArray();
        for (n = 0; n < this.testDataArray.length; ++n) {
            short s;
            short s2 = this.classifyRecordBestKaverage(sArray, this.testDataArray[n]);
            if (s2 == 0 || s2 != (s = this.getLastElement(this.testDataArray[n]))) continue;
            ++n2;
        }
        double d = (double)n2 * 100.0 / (double)n;
        return d;
    }

    protected short classifyRecordBestKaverage(short[] sArray, short[] sArray2) {
        RuleNode ruleNode = this.startRulelist;
        RuleNode ruleNode2 = this.startRulelist;
        this.startRulelist = null;
        this.obtainAllRulesForRecord(sArray2, ruleNode);
        this.keepBestKrulesPerClass(this.kValue, sArray);
        double[] dArray = this.getAverageAccuracies(sArray[0]);
        short s = (short)this.selectClassWithBestAverage(dArray, sArray[0]);
        this.startRulelist = ruleNode2;
        return s;
    }

    private void obtainAllRulesForRecord(short[] sArray, RuleNode ruleNode) {
        if (ruleNode != null) {
            this.obtainAllRulesForRecord(sArray, ruleNode.leftBranch);
            if (this.isSubset(ruleNode.antecedent, sArray)) {
                this.insertRuleIntoRulelist(ruleNode.antecedent, ruleNode.consequent, ruleNode.confidenceForRule, ruleNode.supportForRule);
            }
            this.obtainAllRulesForRecord(sArray, ruleNode.rightBranch);
        }
    }

    private void keepBestKrulesPerClass(int n, short[] sArray) {
        RuleNode ruleNode = this.startRulelist;
        this.startRulelist = null;
        for (int i = 0; i < sArray.length; ++i) {
            this.getFirstKrulesInBinTree(n, sArray[i], ruleNode);
        }
    }

    private int getFirstKrulesInBinTree(int n, short s, RuleNode ruleNode) {
        if (ruleNode != null) {
            if ((n = this.getFirstKrulesInBinTree(n, s, ruleNode.leftBranch)) == 0) {
                return n;
            }
            if (s == ruleNode.consequent[0]) {
                this.insertRuleIntoRulelist(ruleNode.antecedent, ruleNode.consequent, ruleNode.confidenceForRule, ruleNode.supportForRule);
                if (n == 1) {
                    return 0;
                }
            }
            return this.getFirstKrulesInBinTree(n, s, ruleNode.rightBranch);
        }
        return n;
    }

    private double[] getAverageAccuracies(int n) {
        RuleNode ruleNode = this.startRulelist;
        double[][] dArray = new double[2][this.numClasses];
        this.getAverageAccuracies(dArray, n, ruleNode);
        double[] dArray2 = new double[this.numClasses];
        for (int i = 0; i < dArray2.length; ++i) {
            if (dArray[0][i] == 0.0) continue;
            dArray2[i] = dArray[0][i] / dArray[1][i];
        }
        return dArray2;
    }

    private void getAverageAccuracies(double[][] dArray, int n, RuleNode ruleNode) {
        if (ruleNode != null) {
            this.getAverageAccuracies(dArray, n, ruleNode.leftBranch);
            int n2 = ruleNode.consequent[0] - n;
            dArray[0][n2] = dArray[0][n2] + (double)ruleNode.confidenceForRule;
            dArray[1][n2] = dArray[1][n2] + 1.0;
            this.getAverageAccuracies(dArray, n, ruleNode.rightBranch);
        }
    }

    private int selectClassWithBestAverage(double[] dArray, int n) {
        int n2 = 0;
        double d = dArray[n2];
        for (int i = 1; i < dArray.length; ++i) {
            if (!(dArray[i] > d)) continue;
            n2 = i;
            d = dArray[i];
        }
        return n2 + n;
    }

    private short[] createClassifiersArray() {
        short[] sArray = new short[this.numClasses];
        short s = (short)(this.numOneItemSets - this.numClasses + 1);
        for (int i = 0; i < sArray.length; ++i) {
            sArray[i] = (short)(s + i);
        }
        return sArray;
    }

    public void setNumRowsInInputSet() {
        this.numRowsInInputSet = this.numRows;
    }

    public void setNumRowsInTrainingSet(int n) {
        this.numRowsInTrainingSet = n;
    }

    public void setTestDataArray(short[][] sArray) {
        this.testDataArray = sArray;
    }

    public void setKvalue(int n) {
        this.kValue = n;
    }

    public void setOutputRLattNumFlag(boolean bl) {
        this.ruleListAttNumOutputFlag = bl;
    }

    public void setOutputRLschemaFlag(boolean bl) {
        this.ruleListSchemaOutputFlag = bl;
    }

    public void setSupportAndConfidence(double d, double d2) {
        this.support = d;
        this.confidence = d2;
    }

    public double getAverageAccuracy() {
        return this.averageAccuracy;
    }

    public double getSDaccuracy() {
        return this.sdAccuracy;
    }

    public double getAccuracy() {
        return this.accuracy;
    }

    public double getAverageAUCvalue() {
        return this.averageAUCvalue;
    }

    public double getAUCvalue() {
        return this.aucValue;
    }

    public double getAverageNumFreqSets() {
        return this.averageNumFreqSets;
    }

    public double getAvergaeNumUpdates() {
        return this.averageNumUpdates;
    }

    public double getAverageNumCRs() {
        return this.averageNumCRs;
    }

    public int getKvalue() {
        return this.kValue;
    }

    public int getNumCRsVersion2() {
        return this.numCRs;
    }

    @Override
    protected void outputMenu() {
        System.out.println();
        System.out.println("-C  = Confidence (default 80%)");
        System.out.println("-F  = Training file name");
        System.out.println("-N  = Number of classes");
        System.out.println("-O  = Output file name (optional)");
        System.out.println("-S  = Support (default 20%)");
        System.out.println("-T  = Test set file name (optional)");
        System.out.println();
        System.exit(1);
    }

    @Override
    protected void outputSettings() {
        System.out.println("SETTINGS\n--------");
        System.out.println("Training file name            = " + this.fileName);
        if (this.testSetFileName != null) {
            System.out.println("Test set file name (optional) = " + this.testSetFileName);
        }
        if (this.outputFileName != null) {
            System.out.println("Output file name (optional)   = " + this.outputFileName);
        }
        System.out.println("Support (default 20%)         = " + this.support);
        System.out.println("Confidence (default 80%)      = " + this.confidence);
        System.out.println("Number of classes             = " + this.numClasses);
        System.out.println();
    }

    protected void outputLimits() {
        System.out.println("Max num frequent sets  = 500000");
        System.out.println("Max size of antecedent = 6");
        System.out.println("Number of records in training set = " + this.numRows);
        if (this.isOrderedFlag) {
            System.out.println("NOTE: Data set reordered");
        }
    }

    protected void outputLimits(JTextArea jTextArea) {
        this.textArea.append("Max num frequent sets  = 500000\nMax size of antecedent = 6\n");
        this.textArea.append("Number of records in training set = " + this.numRows + "\n");
        if (this.isOrderedFlag) {
            this.textArea.append("NOTE: Data set reordered\n");
        }
    }

    public void outputNumClasses() {
        System.out.println("Number of classes = " + this.numClasses);
    }

    public void outputAccuracy() {
        System.out.println("Accuracy = " + this.twoDecPlaces(this.accuracy));
    }

    public void outputTestDataArray() {
        System.out.println("TEST DATA ARRAY\n---------------");
        for (int i = 0; i < this.testDataArray.length; ++i) {
            System.out.print("Test rec #" + (i + 1) + ": ");
            this.outputItemSet(this.testDataArray[i]);
            System.out.println();
        }
        System.out.println();
    }

    protected void tcvOutput(double[][] dArray) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        this.ouputTCVparam(dArray);
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i][0];
            d2 += dArray[i][1];
            d3 += dArray[i][2];
            d4 += dArray[i][3];
            d5 += dArray[i][4];
        }
        this.averageAccuracy = d / 10.0;
        this.averageAUCvalue = d2 / 10.0;
        this.averageNumFreqSets = d3 / 10.0;
        this.averageNumUpdates = d4 / 10.0;
        this.averageNumCRs = d5 / 10.0;
        double d6 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            double d7 = dArray[i][0] - this.averageAccuracy;
            d6 += Math.pow(d7, 2.0);
        }
        this.sdAccuracy = Math.sqrt(d6 / 9.0);
        this.outputTCVaverages(this.averageAccuracy, this.sdAccuracy, this.averageAUCvalue, this.averageNumFreqSets, this.averageNumUpdates, this.averageNumCRs);
    }

    private void outputTCVaverages(double d, double d2, double d3, double d4, double d5, double d6) {
        String string = "---------------------------------------\nAverage Accuracy\t= " + this.twoDecPlaces(d) + "\nSD Accuracy\t\t= " + this.twoDecPlaces(d2) + "\nAverage AUC value = " + this.fourDecPlaces(this.averageAUCvalue) + "\nAve. # Freq. Sets\t= " + this.twoDecPlaces(d4) + "\nAvergae Num Updates\t= " + this.twoDecPlaces(d5) + "\nAverage Num CRs\t= " + this.twoDecPlaces(d6) + "\n---------------------------------------";
        if (this.textArea == null) {
            System.out.println(string);
        } else {
            this.textArea.append(string + "\n");
        }
    }

    private void ouputTCVparam(double[][] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            String string = "(" + (i + 1) + ") Accuracy = " + this.twoDecPlaces(dArray[i][0]) + ", AUC value = " + this.fourDecPlaces(dArray[i][1]) + ", \t# Freq. Sets = " + (int)dArray[i][2] + ", \t# Updates = " + (int)dArray[i][3] + ", \t# CRs = " + (int)dArray[i][4] + "\n";
            if (this.textArea == null) {
                System.out.println(string);
                continue;
            }
            this.textArea.append(string);
        }
    }
}

